/*!\file SpcNodesx
 * \brief: establish single point constraints on all grids, as well as constraints vector.
 */

#include "./SpcNodesx.h"

#undef __FUNCT__ 
#define __FUNCT__ "SpcNodesx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int SpcNodesx( Vec* pyg, DataSet* nodes,DataSet* constraints){

	int i;
	int numberofdofs;

	/*output: */
	Vec yg=NULL;

	/*First, recover number of dofs from nodes: */
	numberofdofs=nodes->NumberOfDofs();

	/*Allocate yg: */
	yg=NewVec(numberofdofs);

	/*Now, go through constraints, and update the nodes and the constraint vector at the same time: */
	constraints->SetupSpcs(nodes,yg);

	/*Assign output pointers: */
	*pyg=yg;

	return 1;
	
}
