#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of doxygen
version=`echo *.src.tar.gz | sed 's/\.src\.tar\.gz//g' | sed 's/doxygen-//g'`

#Some cleanup
rm -rf src
rm -rf install
rm -rf doxygen-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  doxygen-$version.src.tar.gz

#Move doxygen into src directory
mv doxygen-$version/* src
rm -rf doxygen-$version

#Configure doxygen
cd src && ./configure --prefix "$ISSM_DIR/packages/doxygen/install"

#Compile doxygen
make  -j $NUMCPUS

#Install doxygen
make  install
make install_docs
