
#
# Make_config.mk
#


ifeq ($(MAKELEVEL),0)

   # run only if top-level make:
   SHELL = /bin/sh

   # command-line args, defaults:

   ifdef VER
      version = $(VER)
   else
      version = 5
   endif

   ifdef CLUSTER
      cluster = $(CLUSTER)
   else
      cluster = 0
   endif 

   ifdef BATCH
      batch = $(BATCH)
   else
      batch = 0
   endif



   ifdef PLATFORM
      platform = $(PLATFORM)
   else
      platform = sun
   endif

   ifdef COMPILER
      compiler = $(COMPILER)
   endif 

   ifdef COMPUTLIB
      computlib = $(COMPUTLIB)
   endif 

   ifdef THREAD
      thread = $(THREAD)
   endif 

   ifdef MEMORYMANAGER
      memmgr = $(MEMORYMANAGER)
   else
      memmgr = 0
   endif 

   supported = no

   # branch accordingly:

   ifeq ($(version),5)
      MROOT = /opt/cots/matlab/5.3.1
      ifeq ($(platform),sun)
         supported = yes 
         OBJ_EXT = o
         LIB_EXT = a
		 ifeq ($(cluster),1)
         OBJ_EXT = so
         LIB_EXT = sa
		 endif
		 ifeq ($(batch),1)
		 OBJ_EXT = bo
         LIB_EXT = ba
		 endif
         MEX_EXT = mexsol
         MOPTS  += -f ../mexopts_v5.sh
         CFLAGS += -v
		 CFLAGS += -D_SUN_
      endif
   endif

   ifeq ($(version),6)
      MROOT = /opt/cots/matlab/6.5
      MOPTS = -V5
      ifeq ($(platform),sun)
         supported = yes
         supported = yes 
         OBJ_EXT = o
         LIB_EXT = a
		 ifeq ($(cluster),1)
         OBJ_EXT = so
         LIB_EXT = sa
		 endif
		 ifeq ($(batch),1)
         OBJ_EXT = bo
         LIB_EXT = ba
		 endif
         MEX_EXT = mexsol
         MOPTS  += -f ../mexopts_v651.sh -V5
         CFLAGS += -v
		 CFLAGS += -D_SUN_
      endif
   endif

   ifeq ($(version),7)
      ifeq ($(platform),sun)
         supported = yes
		 OBJ_EXT = o
         LIB_EXT = a
		 ifeq ($(cluster),1)
         OBJ_EXT = so
         LIB_EXT = sa
		 endif
         ifeq ($(batch),1)
         OBJ_EXT = bo
         LIB_EXT = ba
		 endif
		 MEX_EXT = mexsol
         MROOT = /opt/cots/matlab/7.0.4
         MOPTS  += -f ../mexopts_v704.sh -V5
         CFLAGS += -v
		 CFLAGS += -D_SUN_
      endif
      ifeq (lin,$(findstring lin,$(platform)))
         supported = yes 
		 OBJ_EXT = o
         LIB_EXT = a
		 ifeq ($(cluster),1)
         OBJ_EXT = so
         LIB_EXT = sa
		 endif
         ifeq ($(batch),1)
         OBJ_EXT = bo
         LIB_EXT = ba
		 endif
		 MEX_EXT   = mexglx
         MROOT     = /usr/local/matlab
         MOPTS    += -f ../mexopts_v704.sh -V5
         ifeq ($(compiler),icc)
		 CC        = icc
		 CFLAGS  += -static #needed for any intel compilation.
		 else
		 CC        = gcc
		 endif
         CFLAGS   += -D_LINUX_ 
		 PETSCROOT += /proj/ice/Libraries/linux/petsc-2.3.3-p15
		 PETSCARCH += linux-gnu
      endif
      ifeq (win,$(findstring win,$(platform)))
         ifeq ($(compiler),borland)
            supported = yes
			OBJ_EXT = obj
            LIB_EXT   = LIB
			ifeq ($(cluster),1)
			OBJ_EXT = sobj
            LIB_EXT   = sLIB
			endif
            ifeq ($(batch),1)
			OBJ_EXT = bobj
			LIB_EXT = bLIB
			endif
            MEX_EXT   = mexw32
            #MROOT     = C:/MATLAB704
            MROOT     = C:/MATLAB/R2006b
            MBIN      = $(MROOT)/bin/win32
            MEX       = $(MBIN)/mex.bat
            MOPTS     = -f $(MBIN)/mexopts/bcc55opts.bat -V5
            CC        = C:/Program\ Files/Borland/Cbuilder6/Bin/bcc32
            CFLAGS   += -D_WIN_
         endif
      endif
   endif

   # if not yet assigned, set remaining defaults:

   ifndef MBIN
      MBIN     = $(MROOT)/bin
   endif

   ifndef MEX
      MEX      = $(MBIN)/mex
   endif

   ifeq ($(cluster),0)
	   ifndef MINCLUDE
		  MINCLUDE = $(MROOT)/extern/include
	   endif
   endif

   ifeq ($(memmgr),1)
	   CFLAGS  += -D_MEMMGR_
   endif


   # for verbose build:
   #MOPTS  += -v

   CFLAGS  += -I$(MINCLUDE) 

   CFLAGS  += -DMATLAB 

   # define flags for computational libraries.
   ifeq (metis,$(findstring metis,$(computlib)))
		METISDIR=/proj/ice/Libraries/linux/metis-4.0-matlab/
		CFLAGS += -I$(METISDIR)/Lib
		COMPUTLIBS += -L$(METISDIR) -lmetis
	endif

	ifeq (petsc,$(findstring petsc,$(computlib)))
	   CFLAGS   += -I$(PETSCROOT) -I$(PETSCROOT)/include/ -I$(PETSCROOT)/bmake/$(PETSCARCH) 
	   CFLAGS   += -D_PETSC_ 
       COMPUTLIBS+= -L$(PETSCROOT)/lib/$(PETSCARCH)/ -lpetscksp -lpetscdm -lpetscmat -lpetscvec -lpetsc  -lpetscsnes -lpetscts
   endif
    
   ifeq (standard,$(findstring standard,$(computlib)))
	   CFLAGS   += -D_STANDARD_
	   #No need to define COMPUTLIBS: we are using our "home" made routines.
   endif
   
   # activate thread compilation if necessary.
   ifeq ($(thread),yes)
	   CFLAGS   += -D_THREAD_
   endif

   # gcc build
   #GCCOPTS  = gccopts.sh
   #CC       = gcc

   #define libraries that need to be linked with all the mex modules
   
   ifeq ($(cluster),0) #we are building mex module only serially, not on a cluster on in batch mode
   LIBS    = ../Cielo.$(LIB_EXT)
   endif
endif
