
#
# Make_config.mk
#

ifeq ($(MAKELEVEL),0)

   # command-line args, defaults:

   ifdef PARALLEL
      parallel = $(PARALLEL)
   else
      parallel = 0
   endif 

   ifdef COMPILER
      compiler = $(COMPILER)
   endif 

   ifdef THREAD
      thread = $(THREAD)
   endif 
  
   supported = no

   # branch accordingly:
   ifeq (lin,$(findstring lin,$(ISSM_ARCH)))
   supported = yes 
	   ifeq ($(parallel),1)
	   OBJ_EXT = bo
	   LIB_EXT = ba
	   else
	   OBJ_EXT = o
	   LIB_EXT = a
	   endif 
   endif

   
   ifeq ($(compiler),icc)
   CC        = icc
   CFLAGS  += -static #needed for any intel compilation.
   else 
   CC        = gcc
   endif 
   
   #64 bits
   ifeq ($(parallel),1)
   CFLAGS   += -D_LINUX_   -D__GCC4BUILD__ 
   else
   CFLAGS   += -D_LINUX_   -D__GCC4BUILD__  -largeArrayDims
   endif

   #Matlab
   MEX      = $(MATLAB_DIR)/bin/mex
   MINCLUDE = $(MATLAB_DIR)/extern/include 
   ifeq (64,$(findstring 64,$(ISSM_ARCH)))
   MEX_EXT   = mexa64
   endif
   CFLAGS  += -DMATLAB 
   CFLAGS  += -I$(MINCLUDE) 
   MOPTS    += -f $(ISSM_DIR)/etc/mexopts_v76.sh -V5 -D_LINUX_ 

   #Memory manager 
   ifeq ($(memmgr),1)
   CFLAGS  += -D_MEMMGR_
   endif 
   
   
   #METIS
   CFLAGS += -I$(METIS_DIR)/Lib
   COMPUTLIBS += -L$(METIS_DIR) -lmetis
   
   #QHULL
   CFLAGS += -I$(QHULL_DIR)/include/qhull
   COMPUTLIBS += -L$(QHULL_DIR)/lib -lqhull
   
   #PETSC
   CFLAGS   += -I$(PETSC_DIR) -I$(PETSC_DIR)/include/ -I$(PETSC_DIR)/bmake/$(PETSC_ARCH) 
   CFLAGS   += -D_PETSC_ 
   COMPUTLIBS+= -L$(PETSC_DIR)/lib/$(PETSC_ARCH)  -lpetscksp -lpetscdm -lpetscmat -lpetscvec -lpetsc  -lpetscsnes -lpetscts

   # activate thread compilation if necessary.
   ifeq ($(thread),yes)
	   CFLAGS   += -D_THREAD_
   endif 
   
   #define delivery directory
   DELIVERY=$(ISSM_DIR)/bin

ifeq ($(parallel),1)

	#Undefine matlab if already defined. 
	CFLAGS+= -UMATLAB

	#Add some strict compiling 
	CFLAGS  += -Werror-implicit-function-declaration -fno-strict-aliasing -funroll-loops

	#Optimization
	CFLAGS +=  -g3 -O3 

	#Parallel flags
	CFLAGS += -D_PARALLEL_ 

	#MPI
	CC=$(MPI_DIR)/bin/mpicc
	CFLAGS +=  -I$(MPI_DIR)/include
	COMPUTLIBS += -L$(MPI_DIR)/lib -lfmpich -lmpich  -lmpichcxx 	

	#LAPACK and BLAS 
	COMPUTLIBS += -L$(LAPACK_DIR) -lflapack 
	COMPUTLIBS += -L$(BLAS_DIR) -lfblas 

	#SLEPC 
	CFLAGS += -I$(SLEPC_DIR)/include
	COMPUTLIBS += -L$(SLEPC_DIR)/lib/$(SLEPC_ARCH) -lslepc

	#SCALAPACK
	COMPUTLIBS += -L$(SCALAPACK_DIR) -lscalapack

	#BLACS
	COMPUTLIBS += -L$(BLACS_DIR) 

	#PLAPACK Definitions.
	CFLAGS += -I$(PLAPACK_DIR)/INCLUDE -I$(PETSC_DIR)/src/mat/impls/dense/mpi/plapack/
	COMPUTLIBS += -L$(PLAPACK_DIR)/$(PETSC_ARCH) -lPLAPACK

	#Extra definitions
	COMPUTLIBS += -lnsl -lrt -L/usr/X11R6/lib -lX11  

endif 

endif
