#!/bin/csh -f
#
# This script traverses the platform test directories and sends
# mail for the nightly package builds.
#
###################################################
#
# Usage: send_package.csh base_directory web_server
###################################################

echo "Running $0 on `uname -n` at `date`"

# set up the environment variables (global)
# set up the environment variables (global)
setenv DAKOTA_ROOT $1
setenv TEST_SQA $DAKOTA_ROOT/Dakota/test/sqa
source $TEST_SQA/environment.csh

# define base directory, html directory and html_address
# assumes ~/public_html
set web_serv = $2
set html_dir = /home/$USER/public_html/nightly_packages
set html_loc = https://development.sandia.gov/$USER/nightly_packages
echo $DAKOTA_ROOT
echo $html_loc

#if html directory does not exist, create
if ( -e $html_dir ) then
  echo "HTML directory is $html_dir"
else
  mkdir -p $html_dir
  echo "Creating HTML directory $html_dir"
endif

# change into html directory
cd $html_dir
#\rm -f *.out
#\rm -f *.conf
#\rm -f *.err

# set date and htmlize command
set date = `date | awk '{print $2 $3}'`
set emacs = /usr/netpub/bin/emacs
set htmlize = "$TEST_SQA/htmlize.el"
set lhtmlize = "$TEST_SQA/log-htmlize.el"
set log_htmlize = "$emacs -batch -l $htmlize -l $lhtmlize"

foreach p ( `cat $TEST_SQA/package-list-test` )
  set package = `echo $p | awk -F^ '{print $NF}' | awk -F- '{print $1}'`
  if ( $package != 'acro' ) then
    echo $package

    # platform independent input filenames (configure/build logs)
    set coutput = "config_$package.out"
    set cerror  = "config_$package.err"
    set moutput = "make_$package.out"
    set merror  = "make_$package.err"
    set toutput = "test_$package.out"

    # platform independent output filenames (reports)
    set report = "$package""_report.out"

    # report header
    echo "*****************************************" >! $report
    echo "*                                       *" >> $report
    echo "* MAKE LOG FROM NIGHTLY $package BUILDS *" >> $report
    echo "*                                       *" >> $report
    echo "*****************************************" >> $report
    echo "" >> $report

    # initialize switch for success/failure
    set package_err = 0

    foreach platform ( Linux_x86_64 SunOS_sparc AIX_powerpc \
                       Darwin_powerpc )

      # platform header
      echo "*** PLATFORM: $platform ***" >> $report

      # platform dependent input filenames
      set platform_dir = "$DAKOTA_ROOT/scico_$platform/packages"
      set coutput_file = "$platform_dir/$package/$coutput"
      set cerror_file  = "$platform_dir/$package/$cerror"
      set moutput_file = "$platform_dir/$package/$moutput"
      set merror_file  = "$platform_dir/$package/$merror"
      set toutput_file = "$platform_dir/$package/$toutput"
      set conf_file    = "$platform_dir/$package/config.log"

      # platform dependent output filenames
      set coutput_report = "config_$package""_$platform""_$date.out"
      set cerror_report  = "config_$package""_$platform""_$date.err"
      set moutput_report = "make_$package""_$platform""_$date.html"
      set merror_report  = "make_$package""_$platform""_$date.err"
      set toutput_report = "test_$package""_$platform""_$date.out"

      echo "" >> $report
      if ( -e $cerror_file || ! -e $conf_file ) then
        # configure failed
        if ( -e $coutput_file ) then
          echo "$package failed to configure correctly." >> $report
          cp $coutput_file $coutput_report
          scp2 $coutput_report "$USER@$web_serv"":$html_dir/$coutput_report"
          echo "" >> $report
          echo "$html_loc/$coutput_report" >> $report
          if ( -e $cerror_file ) then
            cp $cerror_file $cerror_report
            echo "$html_loc/$cerror_report" >> $report
          endif
        else
          echo "" >> $report
          echo "$package failed to configure: no output." >> $report
          echo "Check network, download/checkout, or script/crontab." >> $report
        endif
        set package_err = 1
      else
        # configure succeeded
        echo "$package configured with " >> $report
        head -7 $conf_file | tail -1 >> $report
        if ( -e $merror_file ) then 
          # make failed
          echo "failed to build." >> $report
          set package_err = 1
          $log_htmlize $moutput_file > $moutput_report
	  scp2 $moutput_report "$USER@$web_serv"":$html_dir/$moutput_report"
          cp $merror_file $merror_report
	  scp2 $merror_report "$USER@$web_serv"":$html_dir/$merror_report"
          echo "" >> $report
          echo "$html_loc/$moutput_report" >> $report
          echo "$html_loc/$merror_report"  >> $report
        else
          # make succeeded
          echo "built successfully" >> $report
          if ( $package == 'Surfpack' || $package == 'OPTPP' || $package == 'DDACE' ) then
            cp $toutput_file $toutput_report
	    scp2 $toutput_report "$USER@$web_serv"":$html_dir/$toutput_report"
            echo "" >> $report
            echo "$package test output:" >> $report
            echo "$html_loc/$toutput_report" >> $report
          endif
        endif
      endif
      echo "" >> $report
    end

    # pick who to send mail to
    if ( $package == 'pico' )  then
      set to_string = "pico-developers@software.sandia.gov"
    else if ( $package == 'COIN' )  then
      set to_string = "pico-developers@software.sandia.gov"
    else if ( $package == 'sgopt' ) then
      set to_string = "coliny-developers@software.sandia.gov"
    else if ( $package == 'coliny' )  then
      set to_string = "coliny-developers@software.sandia.gov"
    else if ( $package == 'utilib' )  then
      set to_string = "utilib-developers@software.sandia.gov"
    else if ( $package == 'acro' ) then
      set to_string = "acro-regression@software.sandia.gov"
    else if ( $package == 'Surfpack' ) then
      set to_string = "surfpack-developers@software.sandia.gov"
    else if ( $package == 'OPTPP' ) then
      set to_string = "opt++-regression@software.sandia.gov"
    else if ( $package == 'DDACE' ) then
      set to_string = "ddace-regression@software.sandia.gov"
    endif
    # (override to_string for testing)

    # send mail
    if ( $package_err != 0) then
      set header = "$package BUILD FAILURE"
      mailx -s "$header" $to_string < $report
    else
      set header = "$package BUILD SUCCESS"
      mailx -s "$header" $to_string < $report
    endif
  endif
end
