/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Description: API for DLL interactions
//- Owner:       Bill Hart
//- Checked by:
//- Version: $Id$

/** \file dll_api.h
    \brief API for DLL interactions */

#ifdef __MINGW32__
#ifdef BUILDING_DAKOTA_DLL
// used when building the API to specify its exports
#define DAKOTA_DLL_FN __declspec(dllexport)
#else
// used by clients importing this DLL
#define DAKOTA_DLL_FN __declspec(dllimport)
#endif
#else
#define DAKOTA_DLL_FN
#endif

extern "C" void DAKOTA_DLL_FN dakota_create(int* dakota_ptr_int);

extern "C" void DAKOTA_DLL_FN dakota_readInput(int id, char* dakotaInput);

extern "C" void DAKOTA_DLL_FN dakota_start(int id);

extern "C" void DAKOTA_DLL_FN dakota_destroy (int id);

extern "C" void DAKOTA_DLL_FN dakota_stop(int* id);

extern "C" const char* DAKOTA_DLL_FN dakota_getStatus(int id);

extern "C" int DAKOTA_DLL_FN get_mc_ptr_int();

extern "C" void DAKOTA_DLL_FN set_mc_ptr_int(int ptr_int);

