namespace webbur2 {

void chebyshev1_compute ( int order, double x[], double w[] );
double chebyshev1_integral ( int expon );

void chebyshev2_compute ( int order, double x[], double w[] );
double chebyshev2_integral ( int expon );

void gegenbauer_compute ( int order, double alpha, double xtab[], 
  double weight[] );
double gegenbauer_integral ( int expon, double alpha );
void gegenbauer_recur ( double *p2, double *dp2, double *p1, double x, int order, 
  double alpha, double c[] );
void gegenbauer_root ( double *x, int order, double alpha,  double *dp2, 
  double *p1, double c[] );

void gen_hermite_compute ( int order, double alpha, double x[], double w[] );
double gen_hermite_integral ( int expon, double alpha );

void gen_laguerre_compute ( int order, double alpha, double x[], double w[] );
double gen_laguerre_integral ( int expon, double alpha );
void gen_laguerre_recur ( double *p2, double *dp2, double *p1, double x, 
  int order, double alpha, double b[], double c[] );
void gen_laguerre_root ( double *x, int order, double alpha, double *dp2, 
  double *p1, double b[], double c[] );

void hermite_compute ( int order, double x[], double w[] );
double hermite_integral ( int n );
void hermite_recur ( double *p2, double *dp2, double *p1, double x, int order );
void hermite_root ( double *x, int order, double *dp2, double *p1 );

void jacobi_compute ( int order, double alpha, double beta, double x[], 
  double w[] );
double jacobi_integral ( int expon, double alpha, double beta );
void jacobi_recur ( double *p2, double *dp2, double *p1, double x, int order, 
  double alpha, double beta, double b[], double c[] );
void jacobi_root ( double *x, int order, double alpha, double beta, 
  double *dp2, double *p1, double b[], double c[] );

void laguerre_compute ( int order, double x[], double w[] );
double laguerre_integral ( int expon );
void laguerre_recur ( double *p2, double *dp2, double *p1, double x, 
  int order, double b[], double c[] );
void laguerre_root ( double *x, int order, double *dp2, double *p1, 
  double b[], double c[] );

void legendre_compute ( int order, double x[], double w[] );
double legendre_integral ( int expon );

double r8_abs ( double x );
double r8_epsilon ( void );
double r8_factorial ( int n );
double r8_factorial2 ( int n );
double r8_gamma ( double x );
double r8_huge ( void );
double r8_hyper_2f1 ( double a, double b, double c, double x );
double r8_psi ( double xx );

void timestamp ( void );

}
