C***********************************************************************
C LHS (Latin Hypercube Sampling) UNIX Library/Standalone. 
C Copyright (c) 2004, Sandia Corporation.  Under the terms of Contract
C DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
C retains certain rights in this software.
C
C This software is distributed under the GNU General Public License.
C For more information, see the README file in the LHS directory. 
C***********************************************************************
C     Last change:  SLD  28 Mar 101   10:15 am
C****************************************************************
C SUBROUTINE BETAIC IS USED IN GENERATING A BETA DISTRIBUTION
C
cc    only 2001 sld changes were comments                               sld01
      SUBROUTINE BETAIC(X,OMX,A,B,N,Y,NZ)
cc    BETAIC is called from BETAFN                                      sld01
C     INCLUDE 'KILLFILE.INC'                                            GDW-96  
      USE KILLFILE                      
C
C     WRITTEN BY D.E. AMOS AND S.L. DANIEL, JANUARY, 1975.
C
C     REFERENCE SC-DR-69 591
C
C     ABSTRACT
C         BETAIC COMPUTES AN N MEMBER SEQUENCE OF BETA DISTRIBUTIONS
C         Y(K)=I(A+K-1,B,X), K=1,...,N , A.GT.0 , B.GT.0 , AND
C         0.LE.X.LE.1, WHERE I(A,B,X) IS THE INCOMPLETE BETA FUNCTION
C         NORMALIZED TO 1. AT X=1. THE RELATION OF THE INCOMPLETE BETA
C         FUNCTION TO THE GAUSS HYPERGEOMETRIC FUNCTION IS USED OVER
C         VARIOUS PARAMETER RANGES WITH SERIES OR ASYMPTOTIC EXPRESSIONS
C         USED FOR EVALUATION STARTING AT A+N-1 AND BO.GT.0. WITH
C         BO=B-INTEGER PART OF B OR 1. THEN A COMBINATION OF FORWARD
C         RECURSION ON THE PARAMETER TO RAISE BO TO B FOLLOWED BY
C         BACKWARD RECURSION ON THE FIRST PARAMETER TO DECREASE A+N-1 TO
C         A GETS THE REQUIRED SEQUENCE. I(A,B,X) SATISFIES A TWO-TERM
C         RELATION IN BOTH PARAMETERS WHERE ADDITIONS CAN BE USED
C         EXCLUSIVELY TO RETAIN SIGNIFICANT DIGITS. BOTH X AND OMX=1.-X
C         ARE ENTERED IN THE CALL LIST TO AVOID LOSSES OF SIGNIFICANCE
C         IN OMX WHEN AN ANALYTICAL EXPRESSION IS AVAILABLE( SEE THE F
C         AND T DISTRIBUTIONS). BETAIC USES HYPGEO AND BETALN.
C
C     DESCRIPTION OF ARGUMENTS
C
C         INPUT
C           X      - ARGUMENT, 0.LE.X.LE.1.
C           OMX    - 1.-X
C           A      - START VALUE OF FIRST PARAMETER, A.GT.0.
C           B      - VALUE OF SECOND PARAMETER,      B.GT.0.
C           N      - NUMBER OF BETA FUNCTIONS IN THE SEQUENCE, N.GE.1
C
C         OUTPUT
C           Y      - A VECTOR WHOSE FIRST N COMPONENTS CONTAIN
C                    Y(K)=I(A+K-1,B,X), K=1,...,N.
C           NZ     - UNDERFLOW FLAG
C                    NZ.EQ.0, A NORMAL RETURN.
C                    NZ.NE.0, UNDERFLOW, Y(K)=0.0, K=N-NZ+1,N RETURNED
C
C     ERROR CONDITIONS
C         IMPROPER INPUT - A FATAL ERROR
C         UNDERFLOW - A NON-FATAL ERROR.
C
C
C
C     BETAIC USES SUBROUTINES BETALN, GAMALN, HYPGEO, ERRCHK, ERRGET,
C                             ERRPRT, ERXSET, ERSTGT
cc    LHS code does not use the ERRPRT routine                          sld01
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION Y(1)
      DIMENSION GBZ(23),PP(35),GCOE(66),WCOE(49)
      DIMENSION GCOE1(59),GCOE2(7)
      EQUIVALENCE(GCOE(1),GCOE1(1)),(GCOE(60),GCOE2(1))
      DATA  WCOE           /-6.41025641025641E-03,-8.33333333333333E-02,
     1-5.00000000000000E-01,-1.46538461538462E+01,-4.58333333333333E+00,
     2-8.25000000000000E+00,-1.10000000000000E+01,-1.10000000000000E+01,
     3-8.25000000000000E+00,-4.58333333333333E+00,-1.83333333333333E+00,
     4-5.00000000000000E-01,-8.33333333333333E-02, 1.91752691752692E-03,
     5 2.10927960927961E-02, 8.72474747474747E-01, 3.16391941391941E-01,
     6 6.32783882783883E-01, 8.85897435897436E-01, 6.63847818847819E+00,
     7 6.32783882783883E-01, 3.16391941391941E-01, 1.05463980463980E-01,
     8 2.10927960927961E-02,-8.41750841750842E-04,-7.57575757575758E-03,
     9-3.03030303030303E-02,-7.07070707070707E-02,-4.31481481481481E+00,
     A-1.06060606060606E-01,-7.07070707070707E-02,-3.03030303030303E-02,
     B-7.57575757575758E-03, 5.95238095238095E-04, 4.16666666666667E-03,
     C 4.29166666666667E-01, 2.08333333333333E-02, 2.08333333333333E-02,
     D 1.25000000000000E-02, 4.16666666666667E-03,-7.93650793650794E-04,
     E-3.96825396825397E-03,-7.93650793650794E-03,-7.93650793650794E-03,
     F-3.96825396825397E-03, 2.77777777777778E-03, 8.33333333333333E-03,
     G 8.33333333333333E-03,-8.33333333333333E-02/
      DATA  GCOE1          /-8.33333333333333E-02, 1.55375180375180E-01,
     1-1.08042328042328E-01, 3.81997721928277E-02,-7.78250845091123E-03,
     2 9.70630021555947E-04,-7.60017468278464E-05, 3.72597920340976E-06,
     3-1.10336922674162E-07, 1.79409630364491E-09,-1.22324747975790E-11,
     4-9.09090909090909E-02, 1.60747354497354E-01,-1.03988095238095E-01,
     5 3.35006062610229E-02,-6.06796859690378E-03, 6.52046360596708E-04,
     6-4.21167695473251E-05, 1.59315751763668E-06,-3.22937334656085E-08,
     7 2.69114445546737E-10,-1.00000000000000E-01, 1.66269841269841E-01,
     8-9.87979497354497E-02, 2.84777336860670E-02,-4.46727109053498E-03,
     9 3.97698045267490E-04,-1.98929398148148E-05, 5.16699735449735E-07,
     A-5.38228891093474E-09,-1.11111111111111E-01, 1.71785714285714E-01,
     B-9.21626984126984E-02, 2.31706532921811E-02,-3.02854938271605E-03,
     C 2.09780092592593E-04,-7.23379629629630E-06, 9.68812003968254E-08,
     D-1.25000000000000E-01, 1.76984126984127E-01,-8.36805555555556E-02,
     E 1.76697530864198E-02,-1.80844907407407E-03, 8.68055555555556E-05,
     F-1.55009920634921E-06,-1.42857142857143E-01, 1.81245000000000E-01,
     G-7.28395061728395E-02, 1.21527777777778E-02,-8.68055555555556E-04,
     H 2.17013888888889E-05,-1.66666666666667E-01, 1.83333333333333E-01,
     I-5.90277777777778E-02, 6.94444444444444E-03,-2.60416666666667E-04,
     J-2.00000000000000E-01, 1.80555555555556E-01,-4.16666666666667E-02/
      DATA  GCOE2          / 2.60416666666667E-03,-2.50000000000000E-01,
     1 1.66666666666667E-01,-2.08333333333333E-02,-3.33333333333333E-01,
     2 1.25000000000000E-01,-5.00000000000000E-01/
C
c     2-14-96 changes:
c     changes made to replace calls to functions I1MACH and R1MACH with
c     calls to LF90 routines for I1MACH(12), I1MACH(13), R1MACH(4), and
c     R1MACH(5).
c     for IBM-compatible PCs functions I1MACH and R1MACH set:
c         I1MACH(12) = -125,  I1MACH(12) = EMIN, the smallest exponent E
c         I1MACH(13) =  127,  I1MACH(13) = EMAX, the largest exponent E
c         R1MACH(4) = 1.19E-07,
c         R1MACH(4) = B**(1-T), the largest relative spacing
c         R1MACH(5) = 0.3010299956,  R1MACH(5) = LOG10(B)
c     note: results of a test program checking the largest exponent
c           by computation and calls to the LF90 function gave 128
c           (rather than 127) in both cases;  the smallest exponent
c           by computation gave -125 while the function call returned a
c           value of -126.  For this reason 1 has been added to the result
c           returned by the LF90 function call in these changes.
c
      DOUBLE PRECISION RARG, DGTS, RADI, R1MACH4, R1MACH5
      Integer I1MACH12, I1MACH13
      Data RARG / 0.0 /
c      E1=ABS(I1MACH(12))      ! changed 2-14-96
c      E2=ABS(I1MACH(13))      ! changed 2-14-96
      I1MACH12 = MINEXPONENT(RARG)
      E1 = ABS (I1MACH12 + 1)
      I1MACH13 = MAXEXPONENT(RARG)
      E2 = I1MACH13
c
c      ALB=R1MACH(5)
c      ELIM=(MIN(E1,E2)*ALB-3.0)*2.303E0
       RADI = RADIX(RARG)    ! convert integer returned from radix to real
       R1MACH5 = LOG10(RADI)
       ELIM=(DMIN(E1,E2)*R1MACH5-3.0D0)*2.303D0
c
c     UR=MAX(1.0E-14,R1MACH(4))
      DGTS = DIGITS(RARG)                  ! converts integer result to real
      R1MACH4 = RADIX(RARG)**(1.0-DGTS)    ! converts integer result to real
      UR=DMAX(1.0D-14,R1MACH4)
c
      FLIM=1.0/(UR*1.0E3)
      P9LIM=1.0-1.0E3*UR
      REL2=UR*1.0E4
      ALIM=UR
      TOL=UR*5.0E3
      MAXR=1000
C
C
C     TESTING OF VARIABLES,  ABS(X+OMX-1).LT.TOL, 0.LE.X.LE.1,
C     A.GT.0,  B.GT.0,  N.GE.1
C
      IF(N.LE.0) GO TO 90
      IF(A.LE.0.0) GO TO 91
      IF(B.LE.0.0) GO TO 92
      NZ=0
      AA=A+FLOAT(N)-1.
      BB=B
      NSAVE=N
      IF (X) 93,25,75
25    DO 30 I=1,N
   30 Y(I)=0.
      RETURN
35    DO 40 I=1,N
   40 Y(I)=1.
      RETURN
75    IF (X.EQ.1.) GO TO 35
      IF(OMX.LT.0.0) GO TO 93
      IF(ABS(X+OMX-1.).GT.TOL) GO TO 93
C
C     COMPUTATION OF BO
C
      IB=BB
      BO=BB-FLOAT(IB)
      IF (BO) 80,80,85
80    BO=1.0
      IB=IB-1
85    DA=AA
      DB=BB
C
C     COMPUTATION OF XLN AND OMXLN BY FORMULA (8)
C
      IF(X.GT.0.9) GO TO 95
      XLN=LOG(X)
      GO TO 105
95    ASSIGN 100 TO IDX
      DX=OMX
      GO TO 120
100   XLN=W
  105 IF(OMX.GT.0.9) GO TO 115
      OMXLN=LOG(OMX)
      GO TO 140
115   ASSIGN 135 TO IDX
      DX=X
C
C     LOGARITHM ROUTINE FOR ARGUMENTS GT 0.9 BY FORMULA (8)
C
120   SW=0.
      A1=DX
      DO 125 K=1,16
      GBZ(K)=A1
125   A1=A1*DX
      K=17
      DO 130 J=1,16
      K=K-1
      SW=SW+GBZ(K)/FLOAT(K)
130   CONTINUE
      W=-SW
      GO TO IDX,(100,135)
135   OMXLN=W
  140 IF(BB.NE.1.0) GO TO 150
C
C     BY FORMULA(1A)
C
      P=EXP(AA*XLN)
      GO TO 395
  150 BP1=B+1.
      IF(BP1*X.LT.(B+.7)/BP1) GO TO 206
      IF(BO.EQ.1.) GO TO 175
      IF(X.GT.0.7) GO TO 215
      IF(X.GT.0.4) GO TO 180
      IF(AA.LE.BB) GO TO 180
C
C     BY FORMULA(4)
C
      T2=1.-DB
      T3=DA+1.
      T4=-X/OMX
      COE=EXP(DA*XLN-T2*OMXLN-BETALN(DA,DB))/DA
C$$$  P=COE*HYPGEO(1.,T2,T3,T4,1.) ! Modified by slbrow, 2-19-2004
      P=COE*HYPGEO(1.0D0,T2,T3,T4,1.0D0)
      GO TO 395
C
C     BY FORMULA(1A)
C
175   P=EXP(AA*XLN)
      GO TO 360
  180 IF(DB.GT.1.) GO TO 200
C
C     BY FORMULA(1)
C
      ASSIGN 395 TO IN1
      GO TO 210
C
  200 ASSIGN 359 TO IN1
      DB=BO
      GO TO 210
  206 ASSIGN 395 TO IN1
C
C     BY FORMULA(1)
C
210   T2=1.-DB
      T3=DA+1.
      COE= EXP(DA*XLN-BETALN(DA,DB))/DA
C$$$  P=COE*HYPGEO(DA,T2,T3,X,1.) ! Modified by slbrow, 2-19-2004
      P=COE*HYPGEO(DA,T2,T3,X,1.0D0)
      GO TO IN1,(395,359)
  215 IF(AA.GT.BB) GO TO 225
C
C     BY FORMULA(3)
C
      T2=1.-AA
      T3=BB+1.
      T4=-OMX/X
      COE= EXP((AA-1.)*XLN+BB*OMXLN-BETALN(AA,BB))/BB
C$$$  P=1.-COE*HYPGEO(1.,T2,T3,T4,1.) ! Modified by slbrow, 2-19-2004
      P=1.-COE*HYPGEO(1.0D0,T2,T3,T4,1.0D0)      
      IF(P.GE.0.1) GO TO 395
C
225   CONTINUE
      IF(AA*OMX.GT.3.) GO TO 280
      IF(AA.LT.20.) GO TO 240
      DA=AA
      GO TO 245
240   IA=AA
      NN=20-IA
      DA=AA+FLOAT(NN+1)
      N=N+NN+1
      IF (DA*OMX.GT.3.) GO TO 280
245   CONTINUE
C
C     P FOR DA*OMX.LE.3. AND DA.GE.20. BY FORMULA (2),(2A),(2B),(2C)
C
      SBP1=BO+1.
      OMSA=1.-DA
C$$$  E=HYPGEO(BO,OMSA,SBP1,OMX,0.0) ! Modified by slbrow, 2-19-2004
      E=HYPGEO(BO,OMSA,SBP1,OMX,0.0)
      PHY=1.+E
      C= EXP(BO*OMXLN-BETALN(DA,BO))/BO
      P=1.-C*PHY
      IF(ABS(P).GE.0.1) GO TO 275
      F=C-1.
      IF(ABS(F).GE.0.1) GO TO 270
C
C     COMPUTE W
C
      RBA=BO/DA
      SAPB=DA+BO
      RSAPB=1./SAPB
      RSAPB2=RSAPB*RSAPB
      SUMK=0.
      AK=1.
      A1=-1.
      DO 260 K=1,13
      A1=-A1*RBA
      SUMK=SUMK+A1/AK
      AK=AK+1.
  260 CONTINUE
      ASUM=0.
      KK=13
      J=1
      DO 261 JJ=1,13,2
      BSUM=0.
      DO 262 K=1,KK
      BSUM=RBA*(BSUM+WCOE(J))
      J=J+1
  262 CONTINUE
      ASUM=RSAPB2*ASUM+BSUM
      KK=KK-2
  261 CONTINUE
      ASUM=RSAPB*ASUM
      ASUM=ASUM+(DA-.5)*SUMK+BO*LOG(SAPB*OMX)-BO-GAMALN(SBP1,0.)
      F=0.
      A2=1.
      AK=1.
      ATEST=ALIM*ABS(ASUM)
      DO 265 K=1,25
      A2=A2*ASUM/AK
      F=F+A2
      IF (ABS(A2).LT.ATEST) GO TO 270
      AK=AK+1.
265   CONTINUE
270   P=-F-E-F*E
  275 IF(BB.LT.1.0) GO TO 395
      GO TO 360
  280 IF(AA*OMX.GT.35.) GO TO 340
      IF(AA.LT.1001.) GO TO 295
      DA=AA
      N=NSAVE
      GO TO 300
  295 IN=1001.-AA
      INP1=IN+1
      N=NSAVE+INP1
      DA=AA+FLOAT(INP1)
      IF (DA*OMX.LT.35.) GO TO 300
      IN=35./OMX-AA+1.
      INP1=IN+1
      DA=AA+FLOAT(INP1)
      N=NSAVE+INP1
      GO TO 345
300   CONTINUE
      SAM1=DA-1.
      ZZ=SAM1*OMX
C
C     BIG GAMMA(BO,ZZ), 3.LT.ZZ.LT.35., ZZ=(DA-1)*OMX BY FORMULA (5)
C
      KFLAG=0
      NBAR=20
  305 IF(NBAR.GT.MAXR) GO TO 94
      RNP1=0.0
      SN=NBAR+1
      DO 310 J=1,NBAR
      SN=SN-1.
      RN=ZZ+(SN-BO)*RNP1/(SN+RNP1)
310   RNP1=RN
      IF(KFLAG.NE.0) GO TO 320
      KFLAG=1
      NBAR=NBAR+NBAR
      RSAVE=RN
      GO TO 305
320   RTEST=ABS((RSAVE-RN)/RN)
      IF(RTEST.LE.REL2) GO TO 330
      RSAVE=RN
      NBAR=NBAR+NBAR
      GO TO 305
330   R1= EXP(BO*LOG(ZZ)-ZZ)
      GBZ(1)=R1/RN
C
C     RECURSION FOR BIG GAMMA(BO+K,ZZ), K=1,2,...23 BY FORMULA (6)
C
      AJ=0.
      DO 335 K=2,23
      GBZ(K)=(AJ+BO)*GBZ(K-1)+R1
      AJ=AJ+1.
      R1=R1*ZZ
335   CONTINUE
C
C     P FOR 0.965.LE.X.LT.0.997 AND DA.GE.1001 BY FORMULA (7)
C
      RA1=1./SAM1
      ASUM=0.
      K1=13
      K2=23
      J=1
      DO 336 KK=1,11
      BSUM=0.
      DO 337 K=K1,K2
      BSUM=BSUM+GCOE(J)*GBZ(K)
      J=J+1
  337 CONTINUE
      K1=K1-1
      K2=K2-2
      ASUM=RA1*(ASUM+BSUM)
  336 CONTINUE
      ASUM=ASUM+GBZ(1)
C
      COE =  EXP(-BETALN(DA,BO) - BO*LOG(SAM1))
      P=COE*ASUM
      GO TO 275
C
C     P FOR 0.7.LT.X.LT.0.965 AND DA*OMX.GT.35. BY FORMULA (4A)
C
340   DA=AA
345   CONTINUE
      A1=1.
      DAK=DA+1.
      DKBO=1.-BO
      RAT=-X/OMX
      DO 350 K=1,35
      A1=(RAT*DKBO/DAK)*A1
      PP(K)=A1
      DAK=DAK+1.
      DKBO=DKBO+1.
350   CONTINUE
      S=0.
      J=36
      DO 355 K=1,35
      J=J-1
355   S=S+PP(J)
      S=S+1.
      COE= EXP(DA*XLN+(BO-1.)*OMXLN-BETALN(DA,BO))/DA
      P=S*COE
      GO TO 275
C
C     FORWARD RECURRENCE BY FORMULA (12A)
C
  359 DB=BB
360   IF (IB.LE.0) GO TO 395
      S=DA*XLN+BO*OMXLN-BETALN(DA,BO)-LOG(BO)
C
C     SCALING FOR UNDERFLOW
C
      IF(S.GE.-ELIM .AND. P.GT.0.0) GO TO 385
  366 FF=1.
      P=0.
      SUM=0.
375   IF (IB.EQ.0) GO TO 395
      IF(FF.GE.FLIM) GO TO 380
      SUM=SUM+FF
      FF=FF*((BO+DA)/(BO+1.))*OMX
      IB=IB-1
      BO=BO+1.
      GO TO 375
380   S1=S
      S=S+LOG(FF)
      IF(S.LT.-ELIM) GO TO 366
      ZZ=S1+LOG(SUM)
      IF(ZZ.LT.-ELIM) GO TO 366
      P=EXP(ZZ)
  385 TERM=EXP(S)
      P=P+TERM
      IB=IB-1
      IF (IB.EQ.0) GO TO 395
      AM1=DA-1.
      BKK=BO
      DO 390 KK=1,IB
      BKK=BKK+1.
      TERM=TERM*((BKK+AM1)/BKK)*OMX
      P=P+TERM
  390 CONTINUE
395   CONTINUE
      IF(N.NE.1) GO TO 405
      Y(1)=P
      IF(P.EQ.0.0) NZ=1
      GO TO 440
C
C     BACKWARD RECURRENCE BY FORMULA (9A)
C
405   DAM1=DA-1.
      DBM2=DB-2.
      S=DAM1*XLN+DB*OMXLN-BETALN(DA,DB)-LOG(DB+DAM1)
C
C     SCALING FOR UNDERFLOW
C
      IF(S.GE.-ELIM .AND. P.GT.0.0) GO TO 430
      IF(P.LT.P9LIM) GO TO 411
      DO 406 I=1,NSAVE
  406 Y(I)=1.
  407 N=NSAVE
      RETURN
  411 FF=1.
      P=0.
      SUM=0.
  420 CONTINUE
      IF(N.EQ.1) GO TO 412
      IF(FF.GE.FLIM) GO TO 425
      SUM=SUM+FF
      FF=FF*(DA-1.)/((DA+DBM2)*X)
      DA=DA-1.
      N=N-1
      GO TO 420
  412 DO 413 I=1,NSAVE
  413 Y(I)=0.
      N =NSAVE
      NZ=N
      RETURN
425   S1=S
      S=S+LOG(FF)
      IF(S.LT.-ELIM) GO TO 411
      ZZ=S1+LOG(SUM)
      IF(ZZ.LT.-ELIM) GO TO 411
      P=EXP(ZZ)
  430 TERM=EXP(S)
      IF(N-NSAVE) 431,434,432
  431 IS=N+1
      DO 429 K=IS,NSAVE
  429 Y(K)=0.
      NZ=NSAVE-N
      Y(N)=P
      IF(N-2) 440,408,409
  408 Y(1)=P+TERM
      GO TO 440
  409 KL=N-1
      GO TO 435
  434 Y(NSAVE)=P
      KL=NSAVE-1
      IF(KL.GT.1) GO TO 435
  441 Y(1)=P+TERM
      GO TO 440
  432 KL=N-NSAVE
      DO 433 K=1,KL
      P=P+TERM
      TERM=TERM*(DA-1.)/((DA+DBM2)*X)
      DA=DA-1.
  433 CONTINUE
      Y(NSAVE)=P
      KL=NSAVE-1
      IF(KL-1) 440,441,435
  435 P=P+TERM
      Y(KL)=P
      KL=KL-1
      KK=KL
      DO 436 K=1,KL
      TERM=TERM*(DA-1.)/((DA+DBM2)*X)
      DA=DA-1.
      Y(KK)=TERM+Y(KK+1)
  436 KK=KK-1
440   N=NSAVE
      DO 442 I=1,N
      IF(Y(I).GT.1.) Y(I)=1.
  442 CONTINUE
      RETURN
C
   90 CALL ERRCHK(32,'IN BETAIC, IMPROPER INPUT FOR N.')
      If(KLLERR) Return
      RETURN
   91 CALL ERRCHK(32,'IN BETAIC, IMPROPER INPUT FOR A.')
      If(KLLERR) Return
      RETURN
   92 CALL ERRCHK(32,'IN BETAIC, IMPROPER INPUT FOR B.')
      If(KLLERR) Return
      RETURN
   93 CALL ERRCHK(39,'IN BETAIC, IMPROPER INPUT FOR X OR OMX.')
      If(KLLERR) Return
      RETURN
   94 CALL ERRCHK(67,  'IN BETAIC, NO CONVERGENCE IN CONTINUED FRACTION
     1FOR GAMMA FUNCTION.')
      If(KLLERR) Return
      RETURN
      END
