/*  _________________________________________________________________________
 *
 *  UTILIB: A utility library for developing portable C++ codes.
 *  Copyright (c) 2001, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README file in the top UTILIB directory.
 *  _________________________________________________________________________
 */


//
// A simple test routine for MPI
//
#include <utilib/utilib_config.h>
#include <utilib/mpiUtil.h>
#include <utilib/CharString.h>

using namespace utilib;

int test_mpitest(int argc, char** argv)
{
#ifdef UTILIB_HAVE_MPI
	uMPI::init(&argc,&argv);

	int rank = uMPI::rank;
	int size = uMPI::size;
	std::cout << "My rank is " << rank << " out of " << size << std::endl;
	if (rank == 0) {
	uMPI::send(&rank, 1, MPI_INT, rank+1, 0);
	}

	int buf;
	MPI_Status status;
	if (rank > 0) {
	   int dest = rank-1;
	   std::cout << "Processor " << rank << " waiting for " << dest << std::endl;
	   uMPI::recv((void*)&buf, 1, MPI_INT, dest, 0, &status);
	   }
	else {
	   int dest = size-1;
	   std::cout << "Processor " << rank << " waiting for " << dest << std::endl;
	   uMPI::recv((void*)&buf, 1, MPI_INT, dest, 0, &status);
	   }
	std::cout << "Processor " << rank << " received a message from processor " << buf << std::endl;
	if (rank == (size-1))
	   uMPI::send(&rank, 1, MPI_INT, 0, 0);
	else
	   uMPI::send(&rank, 1, MPI_INT, rank+1, 0);
	uMPI::done();

#else
	std::cerr << "MPI is not configured right now!" << std::endl;
#endif
	return 0;
}
