/*  _________________________________________________________________________
 *
 *  PICO: A C++ library of scalable branch-and-bound and related methods.
 *  Copyright (c) 2001, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README file in the top PICO directory.
 *  _________________________________________________________________________
 */

/**
 * \file serialQSAcache.h
 * \author William Hart
 *
 * Defines the pebbl::serialQSACache class.
 */

#ifndef __serialQSACache_h
#define __serialQSACache_h

#include <pebbl/BestIncumbentRepository.h>
#include <pebbl/QSAProblem.h>


///
/// A subclass of BestIncumbentRepository, which specializes the 
/// write method for QSA solutions.
///
template <class PointT>
class serialQSACache : public pebbl::BestIncumbentRepository<PointT>
{
public:

  ///
  serialQSACache() :info(0) {}

  ///
  virtual ~serialQSACache() {}

  ///
  void write(std::ostream& os) const;

  ///
  QSAProblem* info;
};


template <class PointT>
void serialQSACache<PointT>::write(std::ostream& os) const
{
os << "Size " << this->tree.size() << std::endl;
const utilib::SimpleSplayTreeItem<pebbl::PointList<PointT> >* node = this->tree.find_rank(0);

int plength = info->rCount.size();
BasicArray<BasicArray<double> > mat(max(info->rCount));
for (int i=0; i<mat.size(); i++) {
  mat[i].resize(plength);
  mat[i] << 0.0;
  }

int count=0;
int i=1;

while (node) {
  LinkedList<BasicArray<int> >::const_iterator curr = node->key().points.begin();
  LinkedList<BasicArray<int> >::const_iterator end = node->key().points.end();
  while (curr != end) {
    count++;
    os << "Value: " << node->key().val << "   Solution: ";
    const BasicArray<int>& vec = *curr;
    for (size_type i=0; i<vec.size(); i++) {
      //if (vec[i] >= 20) {flag = false; break;}
      //if (vec[i] < 0)
         //os << " .";
      //else {
         if (vec[i] >= 0) {
            mat[vec[i]][i]++;
            os << " " << (vec[i]+1);
	    }
         else
            os << " .";
         //}
      }
    os << std::endl;
    curr++;
    }
  node = this->tree.find_rank(i++);
  }
//
// Normalize matrix
//
for (int i=0; i<mat.size(); i++)
  for (unsigned int j=0; j<mat[i].size(); j++)
    mat[i][j] /= count;
//
// Print matrix
//
os << std::endl << "Assignment Frequencies:" << std::endl;
os << "Assignment\\Location" << std::endl;
os << "   ";
int oldw = os.width(4);
int oldp = os.precision(2);
os.setf(std::ios::fixed,std::ios::floatfield);
for (unsigned int j=0; j<mat[0].size(); j++)
  os << std::setw(5) << (j+1);
os << std::endl;
for (int i=0; i<mat.size(); i++) {
  os.fill(' ');
  os << std::setw(3) << (i+1) << " ";
  os.fill('0');
  for (unsigned int j=0; j<mat[i].size(); j++) {
    if (i >= info->rCount[j])
       os << "     ";
    else if (mat[i][j] == 0.0)
       os << "0.00 ";
    else
       os << mat[i][j] << " ";
    }
  os << std::endl;
  }
os.width(oldw);
os.precision(oldp);
}

#endif
