/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

#if !defined(_POPULATION)
#define _POPULATION

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "individual.h"
#include "consts.h"
#include <string.h>
#include <iostream.h>
#include <stdio.h>
#include <iomanip.h>
#include <fstream.h>

class population  
{
public:
	void print_ParetoOptimal_fn(int g, ofstream &f);
	void print_ParetoOptimal_x(int g, ofstream &f);
	void print_ParetoOptimal(int g, ofstream &f);
	void print(int g, ofstream &f);
	
	population &operator=(const population &pop);
	void set_pop_size(int s);
	
	void cal_standarddeviation();   // calculate standard deviation
	void cal_averagefitness();      // calculate average fitness
	
	void rankingN();   // ranking (without noise)
	void rankingC();   // ranking (without noise)
	void statistic(int g,ofstream &f);
	
	//void print(int g,ofstream &f);
	
	int  check_dominationC(individual &id1, individual &id2);
	int  check_ParetoOptimalC(individual &id1,int level);
	
	int  check_dominationN(individual &id1, individual &id2);
	int  check_ParetoOptimalN(individual &id1,int level);
	
	population();
	population(int size);
	
	virtual ~population();
	// used to be private:
	
	
	int pop_size;                // population size
	double average_fitness;      // global average fitness
	double standard_deviation;   // global standard deviation
	
	
	individual *individuals;     // population
	

	int rank_level;
	int n_nondominated_set;
};

#endif // !defined(AFX_POPULATION_H__BCDAA976_6C90_446F_88C3_AAE8EE950D64__INCLUDED_)
