/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

//#include "stdafx.h"
#include "operators_SPEA2.h"


operators_SPEA2::~operators_SPEA2()
{
	if (max_values) {delete [] max_values; max_values=NULL;}
	if (min_values) {delete [] min_values; min_values=NULL;}
	if (obj) delete obj;
}
void operators_SPEA2::crossover(population &pop)
{
	individual mate1,mate2;
	int size=pop.pop_size;
	int CH_LEN=pop.individuals[0].chromosome_len;
	
	
	int csite=0,i,index, counter=0;
	
	int nc=0;	
	
	
	unsigned int *cc1=new unsigned int[CH_LEN]; 
	unsigned int *cc2=new unsigned int[CH_LEN];
	unsigned int *cm1=new unsigned int[CH_LEN];
	unsigned int *cm2=new unsigned int[CH_LEN];
	individual temp;//=NULL;
	index=0;
	temp=pop.individuals[0];
	while (counter<size)
	{
		// selcect parents
		
		mate1=pop.individuals[index] ;
		index++;
		
		mate2=pop.individuals[index];
		index++;
		copyarray(cm1,mate1.Bgenes,CH_LEN);
		copyarray(cm2,mate2.Bgenes,CH_LEN);
		
		
		//crossover
		double r=rnd.nextDouble();
		if (r<=pc) // do crossover
		{
			nc++;
			csite=(int)(rnd.nextDouble()*(CH_LEN));
			if (csite>=CH_LEN) csite=CH_LEN-1;	
			for (i=0;i<csite;i++)
			{
				cc1[i]=cm1[i];cc2[i]=cm2[i];
			}
			for (i=csite;i<CH_LEN;i++)
			{
				cc1[i]=cm2[i];cc2[i]=cm1[i];
			}
		}
		else  //  copying
		{
			for (i=0;i<CH_LEN;i++)
			{
				cc1[i]=cm1[i];
				cc2[i]=cm2[i];
			}
		}
		
		
		temp.set_chromosome(cc1);
		set_objectivevalue(temp,temp.Dgenes); 
		pop.individuals[counter]=temp; 
		
		
		temp.set_chromosome(cc2); 
		set_objectivevalue(temp,temp.Dgenes);
		pop.individuals[counter+1]=temp;
		counter += 2;
    }
	
	if (cc1) {delete [] cc1;cc1=NULL;}
	if (cc2) {delete [] cc2;cc2=NULL;}
	if (cm1) {delete [] cm1;cm1=NULL;}
	if (cm2) {delete [] cm2;cm2=NULL;}
}

void operators_SPEA2::mutation(population &pop)
{
	if ((pm<=0)||(pm>1)) return;
	
	int size=pop.pop_size;
	int CH_LEN=pop.individuals[0].chromosome_len;
	
	
	int i,counter=0;
	double r;
	int nc=0;	
	unsigned int *cm1=new unsigned int[CH_LEN];
	
	
	individual mate1;
	individual temp;//=NULL;
	temp=pop.individuals[0];
	while (counter<size)
	{
		mate1=pop.individuals[counter];
		copyarray(cm1,mate1.Bgenes,CH_LEN);
		
		for (i=0;i<CH_LEN;i++)
		{
			r=rnd.nextDouble();
			if (r<=pm)
			{
				cm1[i]=(cm1[i]==0)?1:0;
			}
		}
		
		
		temp.set_chromosome(cm1);
		set_objectivevalue(temp,temp.Dgenes); 
		
		pop.individuals[counter]=temp; 
		
		counter += 1;
	}
	
	if (cm1) {delete [] cm1;cm1=NULL;}
}

void operators_SPEA2::set_objectivevalue_maxmin(population &p, int size)
{
	int i,j;
	int p_size=p.pop_size; 
	min_values= new double[size];
	max_values= new double[size];
	for (i=0;i<size;i++)
	{
		
		
		min_values[i]=p.individuals[0].DfitnessN[i];
		max_values[i]=p.individuals[0].DfitnessN[i];
		for (j=1;j<p_size;j++)
		{	
			
			if (p.individuals[j].DfitnessN[i]<min_values[i])
				min_values[i]=p.individuals[j].DfitnessN[i];
			
			if (p.individuals[j].DfitnessN[i]>max_values[i])
				max_values[i]=p.individuals[j].DfitnessN[i];
		}	
	}
}

void operators_SPEA2::copyarray(unsigned int *&d, unsigned int *s,int size)
{
	for (int i=0;i<size;i++)
		d[i]=s[i];
}

void operators_SPEA2::initialize_population(const int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,population &pop)
{
	int i,j;
	double *real_params;   // to store real values
	
	real_params=new double[n_Genes];
	
	
	individual *id_temp=NULL;
	
	
	for(i=0;i<pop.pop_size;i++)
	{
		
		for(j=0;j<n_Genes;j++)     // initialize real values for x1,x2,..xn
			real_params[j]=rnd.nextDouble()*(Ub[j]-Lb[j]);
		if (id_temp) {delete id_temp;id_temp=NULL;}	
		id_temp = new individual(n_Genes,n_Objs,GSize,Ub,Lb,real_params,TRUE); 
		
		
		
		set_objectivevalue(*id_temp,real_params);
		
		
		pop.individuals[i]=*id_temp; 
	}
	if (id_temp) {delete id_temp;id_temp=NULL;}	
	if (real_params) {delete [] real_params; real_params=NULL;}
}

void operators_SPEA2::set_objectivevalue(individual &id, double *real_params) {
    int j,n_Objs=id.InumberofObjs;
    int n_Genes=id.InumberofGenes; 
    
    double *fitness=new double[n_Objs];
    if (dev<=0.0) {
	obj->evaluate( real_params, n_Genes, fitness, n_Objs);
	id.set_DfitnessC(fitness);
	id.set_DfitnessN(fitness);
    } else {
	obj->evaluate( real_params, n_Genes, fitness, n_Objs);
	id.set_DfitnessC(fitness);
		
//		for(j=0;j<n_Objs;j++)
//		{
//			if (objID==5)
//				fitness[j]=rnd.nextGaussian(0.0,dev*25)+ problem5(id.Bgenes,id.chromosome_len,j);
//			else
//				fitness[j]=(rnd.nextGaussian(0.0,dev)+((*obj.objective_value)(real_params,n_Genes,j)));
//		}
	id.set_DfitnessN(fitness);  
    }
    if (fitness) {
    	delete [] fitness;
	fitness=NULL;
    }
}

// current Q_size is inputted, because Q have a fixed size: N1,
// based on Q_size, the function can understand the Q's actual size
void operators_SPEA2::combination(population &R, population &Q, population &P, int Q_size)   // different from NSGA-2
{
	
	int P_size=P.pop_size;
	
	int i;
	for (i=0;i<(P_size+Q_size);i++)
	{
		if (i<P_size)
			R.individuals[i]=P.individuals[i];
		else
			R.individuals[i]=Q.individuals[i-P_size];
	}
}

double operators_SPEA2::eDistance(individual &id1, individual &id2)
{
	int i,NObjs=id1.InumberofObjs;
	double temp=0;
	for (i=0;i<NObjs;i++)
		temp+=pow((id1.DfitnessN[i]-id2.DfitnessN[i]),2) ;
	return sqrt(temp);
}

// ALPHA is threshold in PDE or archive size in SPEA
// the results will be stored in Q. It is different from PDE
void operators_SPEA2::get_nondominated_set(population &Q, population &P, int ALPHA)
{
	int index,i,rk=P.rank_level;      // get number of ranks
	int size=P.pop_size; 
	int *nrank = new int[rk];   // create an array of ranks
	for (i=0;i<rk;i++)
		nrank[i]=0;
	
	for (i=0;i<size;i++)            //  calculate the total for each rank
		nrank[P.individuals[i].rank]+=1; 
	
	int n_more=0,subtotal;
	
	subtotal=nrank[0];
	
	if (subtotal<=ALPHA)
	{
		index=0;
		for (i=0;i<size;i++)
			if (P.individuals[i].rank==0)
			{
				Q.individuals[index]=P.individuals[i];
				index++;
			}
			if (subtotal<ALPHA)
			{
				index=0;
				population temp(size-subtotal);
				for (i=0;i<size;i++)
					if (P.individuals[i].rank!=0)
					{
						temp.individuals[index]=P.individuals[i];
						index++;
					}
					
					sort_by_fitness(temp);
					n_more=ALPHA-subtotal;
					
					for (i=0;i<n_more;i++)
						Q.individuals[subtotal+i]=temp.individuals[i];
			}
			
	}
	else   //  OVER SIZE
	{
		// sort temp
		population temp1(subtotal);
		index=0;
		for (i=0;i<size;i++)
			if (P.individuals[i].rank==0)
			{
				temp1.individuals[index]=P.individuals[i];
				index++;
			}
			
			oversize(temp1,Q);
			//	
	}
	if (nrank) {delete [] nrank;nrank=NULL;}
}


void operators_SPEA2::fitness_assignment(population &P)
{
	int i,j;
	int total_size=P.pop_size;
	int *S = new int[total_size];     // number of solutions , each ith solution dominates
	int *R = new int[total_size];     // raw fitness for each solution
	double *D = new double[total_size];     // density
	
	double *dis= new double[total_size];	
	int k=(int)sqrt((double)total_size);
	
	individual temp;
	// intitialize arrays
	for (i=0;i<total_size;i++)
	{
		S[i]=0; R[i]=0;D[i]=0;dis[i]=0;
	}
	//
	for (i=0;i<total_size;i++)	   // calculate S[i]
	{
		
		temp=P.individuals[i];
		for (j=0;j<total_size;j++)
		{
			if (i!=j)
			{
				if (P.check_dominationN(temp,P.individuals[j])) S[i] +=1;
			}
		}
	}
	for (i=0;i<total_size;i++)	   // calculate R[i]
	{
		
		temp=P.individuals[i];
		
		for (j=0;j<total_size;j++)
		{
			if (i!=j)
			{
				if (P.check_dominationN(P.individuals[j],temp)) R[i] += S[j];
			}
		}
	}
	
	for (i=0;i<total_size;i++)	   // calculate D[i] and global fitness F[i]
	{
		
		temp=P.individuals[i];
		
		for (j=0;j<total_size;j++)
		{
			
			dis[j]=eDistance(temp,P.individuals[j]); 
			
		}
		sort_array(dis,total_size);
		D[i]=1/(dis[k]+2);	
		
		// calculate F[i]
		P.individuals[i].DglobalFitness =R[i]+D[i];  
		
	}
	if (S) {delete [] S; S=NULL;}
	if (R) {delete [] R; R=NULL;}
	if (D) {delete [] D; D=NULL;}
	if (dis) {delete [] dis; dis=NULL;}
	
}

void operators_SPEA2::sort_array(double *&arr, int size)
{
	int i,j;
	double t;
	for (i=0;i<size-1;i++)
		for (j=i+1;j<size;j++)
			if (arr[i]>arr[j])
			{
				t=arr[i];arr[i]=arr[j];arr[j]=t;
			}
}

void operators_SPEA2::sort_by_fitness(population &p)
{
	int size=p.pop_size;
	int i,j;
	individual temp;
	for (i=0;i<size-1;i++)
		for (j=i+1;j<size;j++)
			if (p.individuals[i].DglobalFitness> p.individuals[j].DglobalFitness)
			{
				temp=p.individuals[i];
				p.individuals[i]=p.individuals[j];
				p.individuals[j]=temp;
				
			}
}

void operators_SPEA2::oversize(population &input, population &output)
{
	// cout << "oversize" << endl;
	int i_size=input.pop_size;
	int o_size=output.pop_size;
	
	int i,j;
	double t=0;
	
	distance *dis= new distance[i_size];	
	
	double *sigma = new double[i_size];
	unsigned int *check = new unsigned int[i_size];
	
	individual temp;
	
	int k=1,n_remove=i_size-o_size;
	
	double smallest;
	int index;
	
	//disk[i][0] : 0 -> discard it
	
	for (i=0;i<i_size;i++)
	{
		dis[i].d =new double[i_size]; 
		for (j=0;j<i_size;j++)
			dis[i].d[j]=0;
		check[i]=TRUE;
	}
	///
	for (i=0;i<i_size;i++)	   
	{
		
		temp=input.individuals[i];
		
		for (j=0;j<i_size;j++)
		{
			dis[i].d[j]=eDistance(temp,input.individuals[j]); 
			
		}
		sort_array(dis[i].d,i_size);
		sigma[i]=dis[i].d[1];
	}
	///
	//remove individuals
	index =0;
	while(n_remove>0)
	{
		smallest=D_MAX;
		for(i=0;i<i_size;i++)
		{
			if (check[i])
			{
				if (smallest>sigma[i])
				{
					smallest=sigma[i];
					index=i;
				}
				else if (smallest==sigma[i])
				{
					for(j=2;j<i_size;j++)
					{
						if (dis[index].d[j]>dis[i].d[j])
						{
							smallest=sigma[i];
							index=i;
							break;
						} 
						else if (dis[index].d[j]<dis[i].d[j]) break;
					}
				}
			}
			
		}
		
		check[index]=FALSE;
		////////////////////////////////// update distance list
		for (i=0;i<i_size;i++)	   
		{
			if ((i!=index)	&& (check[i]))
			{
				temp=input.individuals[i];
				for (j=0;j<i_size;j++)
					if (j!=index)		dis[i].d[j]=eDistance(temp,input.individuals[j]); 
					else				dis[i].d[j]=D_MAX; 
					sort_array(dis[i].d,i_size);
					sigma[i]=dis[i].d[1];
			}
		}
		//////////////////////////////////////
		n_remove--;
	}
	index=0;
	for(i=0;i<i_size;i++)
	{
		if (check[i])
		{
			output.individuals[index]=input.individuals[i];
			index++;
		}
		
	}	
	//
	
	
	if (sigma) { delete [] sigma; sigma=NULL;};
	if (check) { delete [] check; check=NULL;};
	for (i=0;i<i_size;i++)
	{
		if (dis[i].d)	{delete [] dis[i].d;dis[i].d=NULL;}
	}
	if (dis) {delete [] dis;dis=NULL;}	
 }
 
 void operators_SPEA2::create_mating_pool(population &PA,population &P)
 {
	 int P_size=P.pop_size;  // population size, the same for both a and p
	 int size=PA.pop_size; 
	 
	 
	 individual mate1,mate2;
	 
	 int index1,index2;
	 double rank1,rank2;
	 int c=0;
	 
	 
	 while(c<P_size)
	 {
		 
		 index1=(int)(rnd.nextDouble()*(size)); 
		 if (index1>=size) index1=size-1;
		 
		 index2=(int)(rnd.nextDouble()*(size));
		 if (index2>=size) index2=size-1;
		 
		 mate1=PA.individuals[index1];
		 mate2=PA.individuals[index2];
		 
		 rank1=mate1.DglobalFitness;
		 rank2=mate2.DglobalFitness;
		 
		 //binary tournament selection
		 if (rank1<=rank2) 
			 P.individuals[c]=mate1; 
		 else 
			 P.individuals[c]=mate2;
		 c += 1;
	 }
	 
 }
 void operators_SPEA2::Evolve(int population_size, int N_generation, int SEED, int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb, int CS)
 {
	 P.set_pop_size(population_size);          // parrent population: size N
	 PA.set_pop_size(CS);
	 
	 
	 int N1=CS;
	 int AS=0;     // current archive size
	 
	 n_GEN=N_generation;
	 n_SEED=SEED;
	 
	 rnd.setSeed(n_SEED);
	 
	 // intialize the population P0, archive set is empty
	 initialize_population(n_Genes,n_Objs,GSize,Ub,Lb,P); 
	 
	 int genNo=0;
	 
	 // print to file
	 
	 
	 char *filename=new char[80];
	 
	 
	 char *st_dev=new char[5];
	 sprintf(st_dev,"%0.2f_",dev);
	 
	 
	 char *st_prob=new char[2];
	 sprintf(st_prob,"%d_",objID);
	 
	 char *st_seed=new char[5];
	 sprintf(st_seed,"%d_",n_SEED);
	 
	 // Main SPEA2 loop	
	 while (genNo<=n_GEN)
	 {
		 cout << genNo << endl;
		 
		 
		 strcpy(filename,".//data//");
		 
		 strcat(filename,st_dev);
		 strcat(filename,st_prob);
		 strcat(filename,st_seed);
		 strcat(filename,"Pareto_SPEA2");
		 //strcat(filename,st);
		 
		 strcat(filename,".txt");
		 ofstream f1(filename,ios::app);
		 
		 strcpy(filename,"");
		 
		 strcpy(filename,st_dev);
		 strcat(filename,st_prob);
		 strcat(filename,st_seed);
		 
		 strcat(filename,"Pareto_noise_SPEA2");
		 //strcat(filename,st);
		 strcat(filename,".txt");
		 
		 ofstream f2(filename,ios::app);
		 
		 ////////////////////////////////////////////////////////////////////////////		
		 //combination P and PA -> R
		 
		 R.set_pop_size(population_size+AS);
		 combination(R,PA,P,AS);
		 
		 // fitness assignment for combinatorial population R
		 fitness_assignment(R); 
		 
		 
		 R.rankingN(); 
		 get_nondominated_set(PA,R,N1);
		 
		 // get archive size (fixed)
		 AS=PA.pop_size; 
		 
		 
		 PA.rankingC(); 
		 f2 << "1000000" << endl;
		 PA.print_ParetoOptimal_fn(genNo,f1); 
		 
		 
		 PA.rankingN(); 
		 f1 << "1000000" << endl;
		 PA.print_ParetoOptimal_fn(genNo,f2); 
		 
		 
		 // mating seletion, crossover and mutation to get P for the next generation
		 create_mating_pool(PA,P);
		 crossover(P);
		 mutation(P); 
		 
		 genNo++;
		 
		 f1.close();
		 f2.close();
		 
		 
	 }
	 
}


