/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// Test the set_subsolver interface
//

#include <acro_config.h>
#include <colin/ColinUtilib.h>
#include "TestOptSolver.h"

using namespace colin;
using namespace std;


int main()
{
OptProblem<vector<double> > prob;
OptSetup(prob,"shell_func9","[-10.0,10.0]^3",0,0,true);

TestOptSolver opt;
AnotherOptSolver sub;
opt.set_solver(&opt);
opt.set_solver(&sub);

vector<double> point(4);
point << 10.0;

opt.set_initial_point(point);
opt.set_problem(prob);
opt.set_parameter("accuracy",39.97);
opt.set_parameter("max_neval",100);

opt.reset();
try {
  opt.minimize();
  }
catch (...) 
  { ucout << "HERE" << endl;}

opt.write_parameters(cout);
return 0;
}
