/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file OptProblemFrag_Bounds.h
 *
 * Defines the colin::OptProblemFragment_Bounds class.
 */

#ifndef colin_OptProblemFrag_Bounds_h
#define colin_OptProblemFrag_Bounds_h

#include <acro_config.h>
#include <colin/OptProblemFrag_Base.h>

namespace colin {


/**
 *  Defines the general elements of an OptProblem that pertain to bounds.
 */
template <class DomainT, class ResponseT>
class OptProblemFragment_Bounds : virtual public OptProblemFragment_Base<DomainT,ResponseT>
{
public:

  /// Constructor.
  OptProblemFragment_Bounds() {}

  /// Destructor.
  virtual ~OptProblemFragment_Bounds() {}

  /// Returns true if some bounds are being enforced
  bool& enforcing_bounds() const
                {return this->state->enforcing_bound_constraints;}

  /// Returns true if bound constraints exist for all parameters
  bool has_all_bounds() const
                {return this->state->has_all_bounds();}

  /// Set integer and real boundary constraints - sparse format
  void set_bounds(const char* format)
                {this->state->set_bounds(format);}
};


}

#endif
