/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file BoundTypeArray.h
 *
 * Defines enumeration types for bounds.
 */

#ifndef __colin_BoundTypeArray_h
#define __colin_BoundTypeArray_h

#include <acro_config.h>
#include <utilib/EnumBitArray.h>
#include <utilib/enum_def.h>

namespace colin {

#if !defined(DOXYGEN)
enum bound_type_enum 	{
			no_bound=0,
			hard_bound=1,
			soft_bound=2,
			periodic_bound=3
			};

typedef utilib::EnumBitArray<1,bound_type_enum> BoundTypeArray;

}

ENUM_STREAMS( colin::bound_type_enum )
#endif

#endif
