/*
===============================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class DesignTarget.

    NOTES:

        See notes of DesignTarget.hpp.

    PROGRAMMERS:

        John Eddy (JE) - University at Buffalo, SUNY (johneddy@eng.buffalo.edu)
                         Sandia National Laboratories (jpeddy@sandia.gov)

    COPYRIGHT:

        This library is free software; you can redistribute it and/or
        modify it under the terms of the GNU Lesser General Public
        License as published by the Free Software Foundation; either
        version 2.1 of the License, or (at your option) any later version.

        This library is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
        GNU Lesser General Public License for more details.

        For a copy of the GNU Lesser General Public License, write to:
            Free Software Foundation, Inc.
            59 Temple Place, Suite 330
            Boston, MA 02111-1307 USA

        Funding for this work was provided by:
            The National Science Foundation
            The University at Buffalo, SUNY
            The Research Foundation of the University at Buffalo, SUNY
            Sandia National Laboratories, Albuquerque, NM

    VERSION:

        1.0.0

    CHANGES:

        Tue Jun 03 16:47:55 2003 - Original Version (JE)



===============================================================================
*/




/*
===============================================================================
Includes
===============================================================================
*/








/*
===============================================================================
Begin Namespace
===============================================================================
*/
namespace Utilities {







/*
===============================================================================
Inline Mutators
===============================================================================
*/






/*
===============================================================================
Inline Accessors
===============================================================================
*/
inline
const DVSortDeque&
DesignTarget::GetDiscards(
    ) const
{
    return _discards;
}

inline
DVSortDeque&
DesignTarget::GetDiscards(
    )
{
    return _discards;
}

inline
const DesignVariableInfoVector&
DesignTarget::GetDesignVariableInfos(
    ) const
{
    return _dvInfos;
}

inline
const ConstraintInfoVector&
DesignTarget::GetConstraintInfos(
    ) const
{
    return _cnInfos;
}

inline
const ObjectiveFunctionInfoVector&
DesignTarget::GetObjectiveFunctionInfos(
    ) const
{
    return _ofInfos;
}







/*
===============================================================================
Inline Public Methods
===============================================================================
*/
inline
std::size_t
DesignTarget::GetNDV(
    ) const
{
    return _dvInfos.size();
}

inline
std::size_t
DesignTarget::GetNOF(
    ) const
{
    return _ofInfos.size();
}

inline
std::size_t
DesignTarget::GetNCN(
    ) const
{
    return _cnInfos.size();
}

template <typename DesCont>
void
DesignTarget::TakeDesigns(
    const DesCont& cont
    )
{
    OTB_DEBUGSCOPE("DesignTarget::TakeDesigns");

    typename DesCont::const_iterator it(cont.begin());
    const typename DesCont::const_iterator  e(cont.end());

    for(; it!=e; ++it)
    {
        OTB_ASSERT(*it != 0);
        (*it)->SetDead(true);
        _discards.insert(*it);
    }
}





/*
===============================================================================
Inline Subclass Visible Methods
===============================================================================
*/








/*
===============================================================================
Inline Private Methods
===============================================================================
*/








/*
===============================================================================
Inline Structors
===============================================================================
*/








/*
===============================================================================
End Namespace
===============================================================================
*/
} // namespace Utilities
