C***********************************************************************
C Dempster-Shafer Evidence Theory implementation.
C Sandia National Laboratories 2006.
C
C At the present time, the Dempster-Shafer Evidence Theory implementation 
C is being distributed as part of the DAKOTA framework, under the DAKOTA GNU
C GPL (see the README, COPYRIGHT, and LICENSE file in the top Dakota 
C directory for more information).
C***********************************************************************
      FUNCTION RAN3(ISEED,MBIG,MSEED,MZ,FAC)
C*****RETURNS A UNIFORM RANDOM DEVIATE BETWEEN 0.0 AND 1.0.  SET ISEED
C*****TO ANY NEGATIVE VALUE TO INITIALIZE OR REINITIALIZE THE SEQUENCE
C*****(W. H. PRESS ET AL., NUMERICAL RECIPES IN FORTRAN (1992), PP. 273-4)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION MA(55)
      SAVE IFF, MA, INEXT, INEXTP
      DATA IFF / 0 /
C
C
C*****CHECK FOR INITIALIZATION
      IF ((ISEED .LT. 0) .OR. (IFF .EQ. 0)) THEN
C********INITIALIZE OR REINITIALIZE SEQUENCE
         IFF=1
         MJ=MSEED - ABS (ISEED)
         MJ=MOD(MJ,MBIG)
         MA(55)=MJ
         MK=1
         DO 1000 I=1,54
            II=MOD (21*I, 55)
            MA(II)=MK
            MK=MJ - MK
            IF (MK .LT. MZ) MK=MK + MBIG
            MJ=MA(II)
 1000    CONTINUE
         DO 3000 K=1,4
            DO 2000 I=1,55
               MA(I)=MA(I) - MA(1+MOD(I+30,55))
               IF (MA(I) .LT. MZ) MA(I)=MA(I) + MBIG
 2000       CONTINUE
 3000    CONTINUE
         INEXT=0
         INEXTP=31
      ENDIF
      INEXT=INEXT + 1
      IF (INEXT .EQ. 56) INEXT=1
      INEXTP=INEXTP + 1
      IF (INEXTP .EQ. 56) INEXTP=1
      MJ=MA(INEXT) - MA(INEXTP)
      IF (MJ .LT. MZ) MJ=MJ + MBIG
      MA(INEXT)=MJ
      RAN3=MJ * FAC
      RETURN
      END
