dnl @synopsis DAC_GSL
dnl
dnl Process DDACE options for GSL
dnl
AC_DEFUN([DAC_GSL],[
  dnl GSL package checks.
  AC_ARG_WITH([gsl],
              AC_HELP_STRING([--with-gsl=<dir>],
                             [use GSL (default is yes), specify the root
                              directory for GSL library (optional)]),
              [],[with_gsl="yes"])

  dnl First process with_gsl arguments
  case $with_gsl in
  dnl GSL is optional for DDACE
  no)
    AC_MSG_NOTICE([DDACE configured without GSL.])
    GSL_ROOT=""
    ;;
  dnl Perform system test later
  system)
    try_system_gsl=yes;
    ;;     
  dnl For yes, check GSL_ROOT, otherwise fallback to system GSL
  yes | "")
    if test -n "$GSL_ROOT" -a -d "$GSL_ROOT"; then
      try_gsl_root=yes;
    else
      try_system_gsl=yes;
    fi
    ;;
  dnl Otherwise, user should have provided an explicit path to GSL
  *)
    if test -n "$withval" -a -d "$withval"; then
      try_gsl_root=yes;
      GSL_ROOT=$withval	
    else
      AC_MSG_ERROR([could not locate specified GSL in $withval])
    fi
    ;;
  esac

  dnl Perform actual tests here to avoid duplicate logic above
  acx_gsl_ok=no;
  if test "x$try_gsl_root" == xyes; then

    AC_MSG_NOTICE([GSL_ROOT $GSL_ROOT is specified in the environment.])
    dnl save_CPPFLAGS=$CPPFLAGS
    dnl CPPFLAGS="$save_CPPFLAGS -I$GSL_ROOT"
    dnl AC_CHECK_HEADERS([gsl_version.h],acx_gsl_ok=yes,acx_gsl_ok=no)
    dnl CPPFLAGS=$save_CPPFLAGS
    dnl Would like to check for libs, but they may not be built yet

  dnl system gsl case will include system libs/headers by default
  elif test "x$try_system_gsl" == xyes; then

    AC_MSG_NOTICE([checking for system GSL...])
    acx_gsl_ok=yes;
    AC_CHECK_LIB([m],[cos],,acx_gsl_ok=no)
    AC_CHECK_LIB([gslcblas],[cblas_dgemm],,acx_gsl_ok=no)
    AC_CHECK_LIB([gsl],[gsl_ran_fdist_pdf],,acx_gsl_ok=no)
    AC_CHECK_HEADERS([gsl/gsl_randist.h],,acx_gsl_ok=no)

  fi

  if test "x$acx_gsl_ok" = xyes; then

    AC_MSG_NOTICE([GSL found])  
    AC_DEFINE([HAVE_GSL],[1],[Macro to handle code which depends on GSL.])
    dnl Do not export GSL build variables in certain cases (i.e. no or system)
    if test -n "$GSL_ROOT"; then
      GSL_CPPFLAGS="-I$GSL_ROOT"
      GSL_LDFLAGS="-L$GSL_ROOT -lgsl"

      AC_SUBST(GSL_ROOT)
      AC_SUBST(GSL_CPPFLAGS)
      AC_SUBST(GSL_LDFLAGS)
    fi

  elif test "x$with_gsl" != xno; then
    AC_MSG_NOTICE([GSL not found])  
  fi

  AM_CONDITIONAL([WITH_GSL], [test "x$acx_gsl_ok" == xyes])

]) 
