dnl Packages

AC_DEFUN([DAK_PACKAGES],[
  dnl BOOST package check.
  AC_ARG_WITH([boost],AS_HELP_STRING([--without-boost],
              [turn Boost support off]),[with_boost=$withval],[with_boost=yes])
  if test "x$with_boost" = xyes; then
    dnl AC_CONFIG_SUBDIRS([packages/boost])
    AC_DEFINE([DAKOTA_BOOST],[1],[Macro to handle code which depends on Boost.])
    AC_DEFINE([BOOST_MULTI_INDEX_DISABLE_SERIALIZATION],[1],
              [Macro to disable dependency on the Boost serialization library.])
  fi
  AM_CONDITIONAL([WITH_BOOST],[test "x$with_boost" = xyes])

  dnl QUADRATURE package check.
  AC_ARG_WITH([quadrature],AS_HELP_STRING([--without-quadrature],
	      [turn QUADRATURE support off]),[with_quadrature=$withval],
	      [with_quadrature=yes])
  if test "x$with_quadrature" = xyes; then
    AC_CONFIG_SUBDIRS([packages/quadrature])
    AC_DEFINE([DAKOTA_QUADRATURE],[1],
	      [Macro to handle code which depends on QUADRATURE.])
  fi
  AM_CONDITIONAL([WITH_QUADRATURE],[test "x$with_quadrature" = xyes])

  dnl Teuchos package checks.
  AC_ARG_WITH([teuchos],
              AC_HELP_STRING([--with-teuchos=DIR],
                             [use Teuchos (default is yes), specify the root
                              directory for Teuchos library]),
              [],[with_teuchos="yes"])
  acx_local_teuchos=no
  case $with_teuchos in
  dnl DAKOTA depends on Teuchos UNCONDITIONALLY
  no)
    AC_MSG_ERROR([DAKOTA cannot be configured without Teuchos. Please specify
                 --with-teuchos OR provide a path to a prebuilt Teuchos.])
    ;;

  dnl For yes, check TEUCHOS_ROOT, otherwise fallback to local Teuchos
  yes | "")
    AC_MSG_CHECKING([for Teuchos])
    if test -n "$TEUCHOS_ROOT" -a -d "$TEUCHOS_ROOT"; then

      AC_MSG_RESULT([using Teuchos in TEUCHOS_ROOT: $TEUCHOS_ROOT])

    elif test -d `pwd`/packages/teuchos; then

      dnl use local teuchos and instruct subpackages to do so as well
      export TEUCHOS_ROOT=`pwd`/packages/teuchos
      acx_local_teuchos=yes
      AC_CONFIG_SUBDIRS([packages/teuchos])
      AC_MSG_RESULT([using local Teuchos in $TEUCHOS_ROOT])

    else
      AC_MSG_NOTICE([could not find Teuchos directory.])
      AC_MSG_NOTICE([need help locating teuchos!])
      AC_MSG_ERROR([PLEASE PROVIDE full path to teuchos, --with-teuchos=<DIR>])
    fi
    ;;

  dnl Otherwise, user should have provided an explicit path to Teuchos
  *)
    AC_MSG_CHECKING([for specified Teuchos])
    TEUCHOS_ROOT=$withval
    if test -n "$TEUCHOS_ROOT" -a -d "$TEUCHOS_ROOT"; then
      AC_MSG_RESULT([using: $TEUCHOS_ROOT])
    else
      AC_MSG_ERROR([could not locate $TEUCHOS_ROOT])
    fi
    ;;
  esac

  dnl Finally, check for INSTALLED Teuchos vs. BUILT, but NOT-installed Teuchos
  if test -d "$TEUCHOS_ROOT/include" -a -d "$TEUCHOS_ROOT/lib"; then
    AC_MSG_NOTICE([Found an INSTALLED teuchos!])
    TEUCHOS_CPPFLAGS="-I$TEUCHOS_ROOT/include"
    TEUCHOS_LDFLAGS="-L$TEUCHOS_ROOT/lib"
  elif test -d "$TEUCHOS_ROOT/src"; then
    TEUCHOS_CPPFLAGS="-I$TEUCHOS_ROOT/src"
    TEUCHOS_LDFLAGS="-L$TEUCHOS_ROOT/src"
  else
    AC_MSG_ERROR([could not find Teuchos library relative to $TEUCHOS_ROOT.])
  fi

  AC_SUBST(TEUCHOS_ROOT)
  AC_SUBST(TEUCHOS_CPPFLAGS)
  AC_SUBST(TEUCHOS_LDFLAGS)

  AM_CONDITIONAL([BUILD_TEUCHOS], [test "x$acx_local_teuchos" = xyes])

  dnl GRAPHICS package checks.
  AC_ARG_WITH([graphics],AS_HELP_STRING([--without-graphics],
  					[turn GRAPHICS support off]),
	      [with_graphics=$withval],[with_graphics=yes])
  if test "x$with_graphics" = xyes; then
    dnl on most platforms, when linking dynamically, it suffices to link
    dnl against pthreads, Xpm, Xt, and Xm (the direct dependencies of plplot
    dnl motif), however exceptions for static linking or specific platforms are
    dnl indicated below
    AC_MSG_NOTICE([DAKOTA graphics: begin checking for dependencies.])
    dakota_graphics_ok=yes
    dnl pthread is required by plplot
    ACX_PTHREAD(,dakota_graphics_ok=no)
    dnl AC_PATH_XTRA is AC_REQUIREd by AC_FIND_XPM so its vars are available,
    dnl e.g, have_x.  TODO: rigorous check for Xpm success
    AC_FIND_XPM 
    dnl X11 mandatory, though not necessary to specify when dynamically linking
    AC_CHECK_LIB([X11],[XDrawLines],
		 [X_EXTRA_LIBS="-lX11 $X_EXTRA_LIBS"],
		 dakota_graphics_ok=no,
		 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
    case "${host_os}" in
	*cygwin*|*darwin*|*linux*)
            dnl these may be required to satisfy dependencies in the static
	    dnl link case (otherwise don't need to be on the link line)
	    AC_CHECK_LIB([Xext],[XShapeCombineMask],
			 [X_EXTRA_LIBS="-lXext $X_EXTRA_LIBS"],
			 dakota_graphics_ok=no,
			 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
	    AC_CHECK_LIB([Xp],[XpGetContext],
			 [X_EXTRA_LIBS="-lXp $X_EXTRA_LIBS"],
			 dakota_graphics_ok=no,
			 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
	;;
	*osf*|*solaris*)
	    dnl these two may be required for dependencies, but don't require
            dnl calling out on the link line -- make them optional
	    AC_CHECK_LIB([Xau],[XauFileName],
			 [X_EXTRA_LIBS="-lXau $X_EXTRA_LIBS"],,
			 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
	    AC_CHECK_LIB([Xaw],[XawInitializeWidgetSet],
			 [X_EXTRA_LIBS="-lXaw $X_EXTRA_LIBS"],,
			 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
	;;
	*)
	;;
    esac
    dnl libXmu required to satisfy dependencies (in static link case) and
    dnl        required to specify explicitly on solaris
    AC_CHECK_LIB([Xmu],[XmuClientWindow],
	         [X_EXTRA_LIBS="-lXmu $X_EXTRA_LIBS"],
		 dakota_graphics_ok=no,
		 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
    dnl libXt and libXm are required directly by motif
    AC_CHECK_LIB([Xt],[XtAppInitialize],
		 [X_EXTRA_LIBS="-lXt $X_EXTRA_LIBS"],
		 dakota_graphics_ok=no,
		 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
    AC_CHECK_LIB([Xm],[XmCreateOptionMenu],
		 [X_EXTRA_LIBS="-lXm $X_EXTRA_LIBS"],
		 dakota_graphics_ok=no,
		 [$X_LIBS $X_EXTRA_LIBS $X_PRE_LIBS])
    dnl only proceed if we passed all checks
    if test x"$dakota_graphics_ok" = xno -o x"$have_x" != xyes; then
      AC_MSG_ERROR([Could not find one or more dependencies needed for DAKOTA graphics; make sure necessary headers and libraries are available or consider configuring --without-graphics.])
    fi
    AC_MSG_NOTICE([DAKOTA graphics: enabled.])
    AC_CONFIG_SUBDIRS([packages/motif])
    AC_CONFIG_SUBDIRS([packages/plplot])
    AC_DEFINE([DAKOTA_GRAPHICS],[1],
	      [Macro to handle code which depends on motif and plplot.])

  fi
  AM_CONDITIONAL([WITH_GRAPHICS],[test "x$with_graphics" = xyes])

  dnl GSL package check.
  AC_ARG_WITH([gsl],
              AC_HELP_STRING([--with-gsl=<dir>],
                             [use GSL (default is yes), specify the root
                              directory for GSL library (optional)]),
              [ ],[want_gsl="yes"])

  acx_local_gsl=no
  case $with_gsl in
  no)
    AC_MSG_NOTICE([NOT building with GSL!])
    GSL_ROOT=""
    ;;

  system)
    AC_MSG_CHECKING([for system GSL])
    AC_CHECK_LIB([gslcblas],[cblas_dgemm])
    AC_CHECK_LIB([gsl],[gsl_ran_gamma_pdf])
    AC_CHECK_HEADERS([gsl/gsl_version.h])
    AC_DEFINE([HAVE_GSL],[1],[Macro to handle code which depends on GSL.])
    AC_MSG_NOTICE([Using system GSL!])
    GSL_ROOT=""
    ;;

  dnl For yes, check GSL_ROOT, otherwise fallback to GSL from SVN checkout
  yes | "")
    AC_MSG_CHECKING([for GSL])
    if test -n "$GSL_ROOT" -a -d "$GSL_ROOT"; then

      AC_MSG_NOTICE([GSL_ROOT is set in the environment])
      dnl future enhancement: more checking for headers in this case
      AC_MSG_RESULT([using GSL in GSL_ROOT: $GSL_ROOT])
      AC_DEFINE([HAVE_GSL],[1],[Macro to handle code which depends on GSL.])

    elif test -d `pwd`/packages/gsl; then

      dnl use SVN checkout of GSL and instruct subpackages to do so as well
      export GSL_ROOT=`pwd`/packages/gsl
      acx_local_gsl=yes
      AC_CONFIG_SUBDIRS([packages/gsl])

      dnl no tests to perform since GSL has yet to be built; trust the SVN co
      AC_MSG_RESULT([using GSL in $GSL_ROOT])
      AC_DEFINE([HAVE_GSL],[1],[Macro to handle code which depends on GSL.])

    else
      AC_MSG_NOTICE([could not find GSL directory.])
      AC_MSG_NOTICE([need help locating gsl!])
      AC_MSG_ERROR([PLEASE PROVIDE full path to gsl, --with-gsl=<DIR>])
    fi

    ;;

  dnl Otherwise, user should have provided an explicit path to GSL
  *)
    AC_MSG_CHECKING([for GSL])
    GSL_ROOT=$withval
    if test -n "$GSL_ROOT" -a -d "$GSL_ROOT"; then

      dnl For now, trust the user (future enhancement would provide addl checks)
      dnl AC_CHECK_HEADERS([gsl/gsl_version.h])

      AC_DEFINE([HAVE_GSL],[1],[Macro to handle code which depends on GSL.])
      AC_MSG_NOTICE([Using the GSL specified on the configure line!])
      AC_MSG_RESULT([using: $GSL_ROOT])

    else
      AC_MSG_ERROR([could not locate $GSL_ROOT])
    fi

    ;;
  esac

  dnl Do not export GSL build variables in certain cases (i.e. no or system)
  if test -n "$GSL_ROOT"; then
    GSL_CPPFLAGS="-I$GSL_ROOT"
    GSL_LDFLAGS="-L$GSL_ROOT"

    AC_SUBST(GSL_ROOT)
    AC_SUBST(GSL_CPPFLAGS)
    AC_SUBST(GSL_LDFLAGS)
  fi

  dnl Conditional WITH_GSL needed to manage sources/flags/etc in Makefiles
  AM_CONDITIONAL([WITH_GSL], [test "x$with_gsl" = xsystem -o -n "$GSL_ROOT" ])

  dnl Do perform build of local packages/gsl in the default case (yes)
  AM_CONDITIONAL([BUILD_GSL], [ test "x$acx_local_gsl" = xyes ])

  dnl Pecos package check.
  dnl AC_ARG_WITH([pecos],AS_HELP_STRING([--without-pecos],
  dnl 	      [turn Pecos support off]),[with_pecos=$withval],[with_pecos=yes])
  dnl if test "x$with_pecos" = xyes; then
     AC_CONFIG_SUBDIRS([packages/Pecos])
     AC_DEFINE([DAKOTA_PECOS],[1],
	       [Macro to handle code which depends on PECOS.])
  dnl fi
  dnl AM_CONDITIONAL([WITH_PECOS],[test "x$with_pecos" = xyes])

  dnl AMPL package check.
  AC_ARG_WITH([ampl],AS_HELP_STRING([--without-ampl],[omit AMPL/solver interface library]),
	      [with_ampl=$withval],[with_ampl=yes])
  if test "x$with_ampl" = xyes; then
    AC_CONFIG_SUBDIRS([packages/ampl])
    AC_DEFINE([DAKOTA_AMPL],[1],[Macro to handle code which depends on AMPL.])
  fi
  AM_CONDITIONAL([WITH_AMPL],[test "x$with_ampl" = xyes])

  dnl SURFPACK package check.
  AC_ARG_WITH([surfpack],AS_HELP_STRING([--without-surfpack],
					[turn SURFPACK support off]),
	      [with_surfpack=$withval],[with_surfpack=yes])
  if test "x$with_surfpack" = xyes -a -d $srcdir/packages/Surfpack; then
    AC_CONFIG_SUBDIRS([packages/Surfpack])
    AC_DEFINE([DAKOTA_SURFPACK],[1],
	      [Macro to handle code which depends on SURFPACK.])
    MAYBE_SURFPACK=Surfpack
  else
    MAYBE_SURFPACK=
  fi
  AC_SUBST([MAYBE_SURFPACK])
  AM_CONDITIONAL([WITH_SURFPACK],[test "x$with_surfpack" = xyes -a \
				       -d $srcdir/packages/Surfpack])
])
