/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        DataResponses
//- Description:  Class implementation
//- Owner:        Mike Eldred

#include "DataResponses.H"


namespace Dakota {

// Default constructor:
DataResponsesRep::DataResponsesRep(): numObjectiveFunctions(0),
  numNonlinearIneqConstraints(0), numNonlinearEqConstraints(0),
  numLeastSqTerms(0), numResponseFunctions(0), methodSource("dakota"),
  intervalType("forward"), referenceCount(1)
{ }


void DataResponsesRep::write(MPIPackBuffer& s) const
{
  s << numObjectiveFunctions << numNonlinearIneqConstraints
    << numNonlinearEqConstraints << numLeastSqTerms << numResponseFunctions
    << primaryRespFnScaleTypes << primaryRespFnScales << primaryRespFnWeights
    << leastSqDataFile << nonlinearIneqLowerBnds << nonlinearIneqUpperBnds
    << nonlinearIneqScaleTypes  << nonlinearIneqScales << nonlinearEqTargets
    << nonlinearEqScaleTypes << nonlinearEqScales << gradientType << hessianType
    << quasiHessianType << methodSource << intervalType << fdGradStepSize
    << fdHessStepSize << idNumericalGrads << idAnalyticGrads
    << idNumericalHessians << idQuasiHessians << idAnalyticHessians
    << idResponses << responseLabels;
}


void DataResponsesRep::read(MPIUnpackBuffer& s)
{
  s >> numObjectiveFunctions >> numNonlinearIneqConstraints
    >> numNonlinearEqConstraints >> numLeastSqTerms >> numResponseFunctions
    >> primaryRespFnScaleTypes >> primaryRespFnScales >> primaryRespFnWeights
    >> leastSqDataFile >> nonlinearIneqLowerBnds >> nonlinearIneqUpperBnds
    >> nonlinearIneqScaleTypes  >> nonlinearIneqScales >> nonlinearEqTargets
    >> nonlinearEqScaleTypes >> nonlinearEqScales >> gradientType >> hessianType
    >> quasiHessianType >> methodSource >> intervalType >> fdGradStepSize
    >> fdHessStepSize >> idNumericalGrads >> idAnalyticGrads
    >> idNumericalHessians >> idQuasiHessians >> idAnalyticHessians
    >> idResponses >> responseLabels;
}


void DataResponsesRep::write(ostream& s) const
{
  s << numObjectiveFunctions << numNonlinearIneqConstraints
    << numNonlinearEqConstraints << numLeastSqTerms << numResponseFunctions
    << primaryRespFnScaleTypes << primaryRespFnScales << primaryRespFnWeights
    << leastSqDataFile << nonlinearIneqLowerBnds << nonlinearIneqUpperBnds
    << nonlinearIneqScaleTypes  << nonlinearIneqScales << nonlinearEqTargets
    << nonlinearEqScaleTypes << nonlinearEqScales << gradientType << hessianType
    << quasiHessianType << methodSource << intervalType << fdGradStepSize
    << fdHessStepSize << idNumericalGrads << idAnalyticGrads
    << idNumericalHessians << idQuasiHessians << idAnalyticHessians
    << idResponses << responseLabels;
}


DataResponses::DataResponses(): dataRespRep(new DataResponsesRep())
{
#ifdef REFCOUNT_DEBUG
  Cout << "DataResponses::DataResponses(), dataRespRep referenceCount = "
       << dataRespRep->referenceCount << endl;
#endif
}


DataResponses::DataResponses(const DataResponses& data_resp)
{
  // Increment new (no old to decrement)
  dataRespRep = data_resp.dataRespRep;
  if (dataRespRep) // Check for an assignment of NULL
    dataRespRep->referenceCount++;

#ifdef REFCOUNT_DEBUG
  Cout << "DataResponses::DataResponses(DataResponses&)" << endl;
  if (dataRespRep)
    Cout << "dataRespRep referenceCount = " << dataRespRep->referenceCount
	 << endl;
#endif
}


DataResponses& DataResponses::operator=(const DataResponses& data_resp)
{
  if (dataRespRep != data_resp.dataRespRep) { // normal case: old != new
    // Decrement old
    if (dataRespRep) // Check for NULL
      if ( --dataRespRep->referenceCount == 0 ) 
	delete dataRespRep;
    // Assign and increment new
    dataRespRep = data_resp.dataRespRep;
    if (dataRespRep) // Check for NULL
      dataRespRep->referenceCount++;
  }
  // else if assigning same rep, then do nothing since referenceCount
  // should already be correct

#ifdef REFCOUNT_DEBUG
  Cout << "DataResponses::operator=(DataResponses&)" << endl;
  if (dataRespRep)
    Cout << "dataRespRep referenceCount = " << dataRespRep->referenceCount
	 << endl;
#endif

  return *this;
}


DataResponses::~DataResponses()
{
  if (dataRespRep) { // Check for NULL
    --dataRespRep->referenceCount; // decrement
#ifdef REFCOUNT_DEBUG
    Cout << "dataRespRep referenceCount decremented to "
         << dataRespRep->referenceCount << endl;
#endif
    if (dataRespRep->referenceCount == 0) {
#ifdef REFCOUNT_DEBUG
      Cout << "deleting dataRespRep" << endl;
#endif
      delete dataRespRep;
    }
  }
}

} // namespace Dakota
