# include <cstdlib>
# include <iostream>
# include <iomanip>
# include <cmath>
# include <cstring> // for strcpy

using namespace std;

# include "sparse_grid_mixed.H"

using namespace webbur;

int main ( void );
void product_mixed_weight_test ( int dim_num, int order_1d[], int order_nd, 
  int rule[] );
void sparse_grid_mixed_index_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] );
void sparse_grid_mixed_point_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] );
void sparse_grid_mixed_size_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] );
void sparse_grid_mixed_unique_index_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] );
void sparse_grid_mixed_weight_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] );
void sparse_grid_mixed_write_test ( int dim_num, int level_max, int rule[], 
  char *file_name );

//****************************************************************************80

int main ( void )

//****************************************************************************80
//
//  Purpose:
//
//    MAIN is the main program for SPARSE_GRID_MIXED_PRB.
//
//  Discussion:
//
//    SPARSE_GRID_MIXED_PRB tests the SPARSE_GRID_MIXED routines.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    01 October 2008
//
//  Author:
//
//    John Burkardt
//
{
  int dim_num;
  char file_name[80];
  int level_max;
  int level_max_max;
  int level_max_min;
  int *order_1d;
  int order_nd;
  int *rule;

  timestamp ( );
  cout << "\n";
  cout << "SPARSE_GRID_MIXED_PRB\n";
  cout << "  C++ version\n";
  cout << "\n";
  cout << "  Test the routines in the SPARSE_GRID_MIXED library.\n";
//
//  PRODUCT_MIXED_WEIGHT_TEST
//
  dim_num = 2;
  order_1d = new int[dim_num];
  rule = new int[dim_num];
  order_1d[0] = 3;
  order_1d[1] = 5;
  order_nd = i4vec_product ( dim_num, order_1d );
  rule[0] = 1;
  rule[1] = 1;
  product_mixed_weight_test ( dim_num, order_1d, order_nd, rule );
  delete [] order_1d;
  delete [] rule;

  dim_num = 2;
  order_1d = new int[dim_num];
  rule = new int[dim_num];
  order_1d[0] = 3;
  order_1d[1] = 7;
  order_nd = i4vec_product ( dim_num, order_1d );
  rule[0] = 1;
  rule[1] = 5;
  product_mixed_weight_test ( dim_num, order_1d, order_nd, rule );
  delete [] order_1d;
  delete [] rule;

  dim_num = 2;
  order_1d = new int[dim_num];
  rule = new int[dim_num];
  order_1d[0] = 3;
  order_1d[1] = 3;
  order_nd = i4vec_product ( dim_num, order_1d );
  rule[0] = 3;
  rule[1] = 7;
  product_mixed_weight_test ( dim_num, order_1d, order_nd, rule );
  delete [] order_1d;
  delete [] rule;

  dim_num = 3;
  order_1d = new int[dim_num];
  rule = new int[dim_num];
  order_1d[0] = 2;
  order_1d[1] = 3;
  order_1d[2] = 3;
  order_nd = i4vec_product ( dim_num, order_1d );
  rule[0] = 1;
  rule[1] = 3;
  rule[2] = 5;
  product_mixed_weight_test ( dim_num, order_1d, order_nd, rule );
  delete [] order_1d;
  delete [] rule;
//
//  SPARSE_GRID_MIXED_SIZE_TEST
//
  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 1;
  sparse_grid_mixed_size_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 3;
  sparse_grid_mixed_size_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 4;
  sparse_grid_mixed_size_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 7;
  sparse_grid_mixed_size_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 3;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 2;
  rule[2] = 5;
  sparse_grid_mixed_size_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;
//
//  SPARSE_GRID_MIXED_UNIQUE_INDEX_TEST
//
  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 1;
  sparse_grid_mixed_unique_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 3;
  sparse_grid_mixed_unique_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 4;
  sparse_grid_mixed_unique_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 7;
  sparse_grid_mixed_unique_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 3;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 2;
  rule[2] = 5;
  sparse_grid_mixed_unique_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;
//
//  SPARSE_GRID_MIXED_INDEX_TEST
//
  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 1;
  sparse_grid_mixed_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 3;
  sparse_grid_mixed_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 4;
  sparse_grid_mixed_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 7;
  sparse_grid_mixed_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 3;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 2;
  rule[2] = 5;
  sparse_grid_mixed_index_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;
//
//  SPARSE_GRID_MIXED_POINT_TEST
//
  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 1;
  sparse_grid_mixed_point_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 3;
  sparse_grid_mixed_point_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 4;
  sparse_grid_mixed_point_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 7;
  sparse_grid_mixed_point_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 3;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 2;
  rule[2] = 5;
  sparse_grid_mixed_point_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;
//
//  SPARSE_GRID_MIXED_WEIGHT_TEST
//
  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 1;
  sparse_grid_mixed_weight_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 3;
  sparse_grid_mixed_weight_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 4;
  sparse_grid_mixed_weight_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 2;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 7;
  sparse_grid_mixed_weight_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;

  dim_num = 3;
  level_max_min = 0;
  level_max_max = 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 2;
  rule[2] = 5;
  sparse_grid_mixed_weight_test ( dim_num, level_max_min, level_max_max, rule );
  delete [] rule;
//
//  SPARSE_GRID_MIXED_WRITE_TEST
//
  dim_num = 2;
  level_max= 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 1;
  strcpy ( file_name, "sparse_grid_mixed_d2_l2_ccxcc" );
  sparse_grid_mixed_write_test ( dim_num, level_max, rule, file_name );
  delete [] rule;

  dim_num = 2;
  level_max= 3;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 3;
  strcpy ( file_name, "sparse_grid_mixed_d2_l3_ccxgp" );
  sparse_grid_mixed_write_test ( dim_num, level_max, rule, file_name );
  delete [] rule;

  dim_num = 2;
  level_max= 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 4;
  strcpy ( file_name, "sparse_grid_mixed_d2_l2_ccxgl" );
  sparse_grid_mixed_write_test ( dim_num, level_max, rule, file_name );
  delete [] rule;

  dim_num = 2;
  level_max= 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 7;
  strcpy ( file_name, "sparse_grid_mixed_d2_l2_ccxlg" );
  sparse_grid_mixed_write_test ( dim_num, level_max, rule, file_name );
  delete [] rule;

  dim_num = 3;
  level_max= 2;
  rule = new int[dim_num];
  rule[0] = 1;
  rule[1] = 2;
  rule[2] = 5;
  strcpy ( file_name, "sparse_grid_mixed_d3_l2_ccxf2xgh" );
  sparse_grid_mixed_write_test ( dim_num, level_max, rule, file_name );
  delete [] rule;
//
//  That's all.
//
  cout << "\n";
  cout << "SPARSE_GRID_MIXED_PRB\n";
  cout << "  Normal end of execution.\n";

  cout << "\n";
  timestamp ( );
  
  return 0;
}
//***************************************************************************80

void product_mixed_weight_test ( int dim_num, int order_1d[], int order_nd, 
  int rule[] )

//***************************************************************************80
//
//  Purpose:
//
//    PRODUCT_MIXED_WEIGHT_TEST computes the weights of a mixed factor product rule.
//
//  Discussion:
//
//    This routine gets the sparse grid indices and determines the
//    corresponding sparse grid weights.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    02 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, int DIM_NUM, the spatial dimension.
//
//    Input, int ORDER_1D[DIM_NUM], the order of the 1D rules.
//
//    Input, int ORDER_ND, the order of the product rule.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
{
  int dim;
  double pi = 3.141592653589793;
  double *weight;
  double weight_sum;
  double weight_sum_error;
  double weight_sum_exact;

  weight_sum_exact = 1.0;

  for ( dim = 0; dim < dim_num; dim++ )
  {
    if ( 1 <= rule[dim] && rule[dim] <= 4 )
    {
      weight_sum_exact = weight_sum_exact * 2.0;
    }
    else if ( 5 == rule[dim] )
    {
      weight_sum_exact = weight_sum_exact * sqrt ( pi );
    }
    else if ( 7 == rule[dim] )
    {
      weight_sum_exact = weight_sum_exact * 1.0;
    }
    else
    {
      cerr << "\n";
      cerr << "PRODUCT_MIXED_WEIGHT_TEST - Fatal error!\n";
      cerr << "  Unexpected value of RULE[" << dim << "] = " << rule[dim] << ".\n";
      exit ( 1 );
    }
  }

  cout << "\n";
  cout << "PRODUCT_MIXED_WEIGHT_TEST:\n";
  cout << "  Compute the weights of a mixed factor product grid.\n";
  cout << "\n";
  cout << "  As a simple test, sum these weights.\n";
  cout << "  They should sum to exactly " << weight_sum_exact << "\n";
  cout << "\n";
  cout << "  Spatial dimension DIM_NUM = " << dim_num << "\n";
  cout << "  1D orders ORDER_1D =        [";
  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << order_1d[dim];
  }
  cout << " ]\n";
  cout << "  1D quadrature index RULE =  [";
  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << rule[dim];
  }
  cout << " ]\n";
//
//  Compute the weights and points.
//
  weight = new double[order_nd];

  product_mixed_weight ( dim_num, order_1d, order_nd, rule, weight );
//
//  Sum the weights.
//
  weight_sum = r8vec_sum ( order_nd, weight );

  weight_sum_error = r8_abs ( weight_sum - weight_sum_exact );

  cout << "\n";
  cout << "    Weight sum  Expected sum    Difference\n";
  cout << "\n";
  cout << "  " << setw(14) << weight_sum
       << "  " << setw(14) << weight_sum_exact
       << "  " << setw(14) << weight_sum_error << "\n";

  delete [] weight;

  return;
}
//***************************************************************************80

void sparse_grid_mixed_index_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] )

//***************************************************************************80
//
//  Purpose:
//
//    SPARSE_GRID_MIXED_INDEX_TEST tests SPARSE_GRID_MIXED_INDEX.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    01 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, int DIM_NUM, the spatial dimension.
//
//    Input, int LEVEL_MAX_MIN, LEVEL_MAX_MAX, the minimum and
//    maximum values of LEVEL_MAX.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
{
  int dim;
  int level_max;
  int point;
  int point_num;
  int *sparse_index;
  int *sparse_order;

  cout << "\n";
  cout << "SPARSE_GRID_MIXED_INDEX_TEST\n";
  cout << "  SPARSE_GRID_MIXED_INDEX returns index and order vectors that\n";
  cout << "  identify each point in a multidimensional sparse grid with mixed factors.\n";
  cout << "\n";
  cout << "  Each sparse grid is of spatial dimension DIM_NUM,\n";
  cout << "  and is made up of product grids of levels up to LEVEL_MAX.\n";
  cout << "\n";
  cout << " Dimension      Rule\n";
  cout << "\n";

  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << setw(8) << dim
         << "  " << setw(8) << rule[dim] << "\n";
  }

  for ( level_max = level_max_min; level_max <= level_max_max; level_max++ )
  {
    point_num = sparse_grid_mixed_size ( dim_num, level_max, rule );

    sparse_order = new int[dim_num*point_num];
    sparse_index = new int[dim_num*point_num];

    sparse_grid_mixed_index ( dim_num, level_max, rule, point_num, 
      sparse_order, sparse_index );

    cout << "\n";
    cout << "  For LEVEL_MAX = " << level_max << "\n";
    cout << "\n";
    for ( point = 0; point < point_num; point++ )
    {
      cout << "  " << setw(4) << point << "  ";
      for ( dim = 0; dim < dim_num; dim++ )
      {
        cout << "  " << setw(3) << sparse_index[dim+point*dim_num]
             << " /" << setw(3) << sparse_order[dim+point*dim_num];
      }
      cout << "\n";
    }
    delete [] sparse_index;
    delete [] sparse_order;
  }
  return;
}
//***************************************************************************80

void sparse_grid_mixed_point_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] )

//***************************************************************************80
//
//  Purpose:
//
//    SPARSE_GRID_MIXED_POINT_TEST tests SPARSE_GRID_MIXED_POINT.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    02 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, int DIM_NUM, the spatial dimension.
//
//    Input, int LEVEL_MAX_MIN, LEVEL_MAX_MAX, the minimum and
//    maximum values of LEVEL_MAX.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
{
  int dim;
  int level_max;
  int point;
  int point_num;
  double *sparse_point;

  cout << "\n";
  cout << "SPARSE_GRID_MIXED_POINT_TEST\n";
  cout << "  SPARSE_GRID_MIXED_POINT returns an array of the points\n";
  cout << "  forming a multidimensional sparse grid with mixed factors.\n";
  cout << "\n";
  cout << "  Each sparse grid is of spatial dimension DIM_NUM,\n";
  cout << "  and is made up of product grids of levels up to LEVEL_MAX.\n";
  cout << "\n";
  cout << " Dimension      Rule\n";
  cout << "\n";

  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << setw(8) << dim
         << "  " << setw(8) << rule[dim] << "\n";
  }

  for ( level_max = level_max_min; level_max <= level_max_max; level_max++ )
  {
    point_num = sparse_grid_mixed_size ( dim_num, level_max, rule );

    sparse_point = new double [ dim_num * point_num ];

    sparse_grid_mixed_point ( dim_num, level_max, rule, point_num, sparse_point );

    cout << "\n";
    cout << "  For LEVEL_MAX = " << level_max << "\n";
    cout << "\n";
    for ( point = 0; point < point_num; point++ )
    {
      cout << "  " << setw(4) << point << "  ";
      for ( dim = 0; dim < dim_num; dim++ )
      {
        cout << "  " << setw(10) << sparse_point[dim+point*dim_num];
      }
      cout << "\n";
    }
    delete [] sparse_point;
  }
  return;
}
//***************************************************************************80

void sparse_grid_mixed_size_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] )

//***************************************************************************80
//
//  Purpose:
//
//    SPARSE_GRID_MIXED_SIZE_TEST tests SPARSE_GRID_MIXED_SIZE, SPARSE_GRID_MIXED_SIZE_TOTAL.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    01 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, int DIM_NUM, the spatial dimension.
//
//    Input, int LEVEL_MAX_MIN, LEVEL_MAX_MAX, the minimum and
//    maximum values of LEVEL_MAX.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
{
  int dim;
  int level_max;
  int level_min;
  int point_num;
  int point_total_num;

  cout << "\n";
  cout << "SPARSE_GRID_MIXED_SIZE_TEST\n";
  cout << "  SPARSE_GRID_MIXED_SIZE returns the number of distinct\n";
  cout << "  points in a multidimensional sparse grid with mixed factors.\n";
  cout << "\n";
  cout << "  SPARSE_GRID_MIXED_SIZE_TOTAL returns the TOTAL number of\n";
  cout << "  points in a multidimensional sparse grid with mixed factors,\n";
  cout << "  without checking for duplication.\n";
  cout << "\n";
  cout << "  Each sparse grid is of spatial dimension DIM_NUM,\n";
  cout << "  and is made up of product grids of levels up to LEVEL_MAX.\n";
  cout << "\n";
  cout << " Dimension      Rule\n";
  cout << "\n";

  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << setw(8) << dim
         << "  " << setw(8) << rule[dim] << "\n";
  }

  cout << "\n";
  cout << " LEVEL_MIN LEVEL_MAX POINT_NUM POINT_NUM\n";
  cout << "                        Unique     Total\n";
  cout << "\n";

  for ( level_max = level_max_min; level_max <= level_max_max; level_max++ )
  {
    point_num = sparse_grid_mixed_size ( dim_num, level_max, rule );

    point_total_num = sparse_grid_mixed_size_total ( dim_num, level_max, rule );

    level_min = i4_max ( 0, level_max + 1 - dim_num );

    cout << "  " << setw(8) << level_min
         << "  " << setw(8) << level_max
         << "  " << setw(8) << point_num
         << "  " << setw(8) << point_total_num << "\n";
  }

  return;
}
//***************************************************************************80

void sparse_grid_mixed_unique_index_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] )

//***************************************************************************80
//
//  Purpose:
//
//    SPARSE_GRID_MIXED_UNIQUE_INDEX_TEST tests SPARSE_GRID_MIXED_UNIQUE_INDEX.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    02 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, int DIM_NUM, the spatial dimension.
//
//    Input, int LEVEL_MAX_MIN, LEVEL_MAX_MAX, the minimum and
//    maximum values of LEVEL_MAX.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
{
  int dim;
  int level_max;
  int level_min;
  int point;
  int point_num;
  int point_total_num;
  int *sparse_unique_index;

  cout << "\n";
  cout << "SPARSE_GRID_MIXED_UNIQUE_INDEX_TEST\n";
  cout << "  SPARSE_GRID_MIXED_UNIQUE_INDEX returns a mapping between\n";
  cout << "  the nonunique and unique points in a sparse grid.\n";
  cout << "\n";
  cout << " Dimension      Rule\n";
  cout << "\n";

  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << setw(8) << dim
         << "  " << setw(8) << rule[dim] << "\n";
  }

  for ( level_max = level_max_min; level_max <= level_max_max; level_max++ )
  {
    point_num = sparse_grid_mixed_size ( dim_num, level_max, rule );

    point_total_num = sparse_grid_mixed_size_total ( dim_num, level_max, rule );

    cout << "\n";
    cout << " LEVEL_MIN LEVEL_MAX POINT_NUM POINT_NUM\n";
    cout << "                        Unique     Total\n";
    cout << "\n";
    level_min = i4_max ( 0, level_max + 1 - dim_num );

    cout << "  " << setw(8) << level_min
         << "  " << setw(8) << level_max
         << "  " << setw(8) << point_num
         << "  " << setw(8) << point_total_num << "\n";

    sparse_unique_index = new int[point_total_num];

    sparse_grid_mixed_unique_index ( dim_num, level_max, rule, point_total_num, 
      sparse_unique_index );

    cout << "\n";
    cout << "     POINT    UNIQUE\n";
    cout << "\n";
    for ( point = 0; point < point_total_num; point++ )
    {
      cout << "  " << setw(8) << point
           << "  " << setw(8) << sparse_unique_index[point] << "\n";
    }
    delete [] sparse_unique_index;
  }
  return;
}
//***************************************************************************80

void sparse_grid_mixed_weight_test ( int dim_num, int level_max_min, 
  int level_max_max, int rule[] )

//***************************************************************************80
//
//  Purpose:
//
//    SPARSE_GRID_MIXED_WEIGHT_TEST checks the sum of the quadrature weights.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    01 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, int DIM_NUM, the spatial dimension.
//
//    Input, int LEVEL_MAX_MIN, LEVEL_MAX_MAX, the minimum and
//    maximum values of LEVEL_MAX.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
{
  int dim;
  int level_max;
  double pi = 3.141592653589793;
  int point;
  int point_num;
  double *sparse_weight;
  double weight_sum;
  double weight_sum_error;
  double weight_sum_exact;

  cout << "\n";
  cout << "SPARSE_GRID_MIXED_WEIGHT_TEST\n";
  cout << "  Compute the weights of a sparse grid.\n";
  cout << "\n";
  cout << "  Each sparse grid is of spatial dimension DIM_NUM,\n";
  cout << "  and is made up of product grids of levels up to LEVEL_MAX.\n";
  cout << "\n";
  cout << " Dimension      Rule\n";
  cout << "\n";

  for ( dim = 0; dim < dim_num; dim++ )
  {
    cout << "  " << setw(8) << dim
         << "  " << setw(8) << rule[dim] << "\n";
  }

  weight_sum_exact = 1.0;

  for ( dim = 0; dim < dim_num; dim++ )
  {
    if ( 1 <= rule[dim] && rule[dim] <= 4 )
    {
      weight_sum_exact = weight_sum_exact * 2.0;
    }
    else if ( 5 == rule[dim] )
    {
      weight_sum_exact = weight_sum_exact * sqrt ( pi );
    }
    else if ( 7 == rule[dim] )
    {
      weight_sum_exact = weight_sum_exact * 1.0;
    }
    else
    {
      cerr << "\n";
      cerr << "SPARSE_GRID_MIXED_WEIGHT_TEST - Fatal error!\n";
      cerr << "  Unexpected value of RULE[" << dim << "] = " << rule[dim] << ".\n";
      exit ( 1 );
    }
  }

  cout << "\n";
  cout << "  As a simple test, sum these weights.\n";
  cout << "  They should sum to exactly " << weight_sum_exact << "\n";

  cout << "\n";
  cout << "     Level      Weight sum  Expected sum    Difference\n";
  cout << "\n";

  for ( level_max = level_max_min; level_max <= level_max_max; level_max++ )
  {
    point_num = sparse_grid_mixed_size ( dim_num, level_max, rule );

    sparse_weight = new double[point_num];

    sparse_grid_mixed_weight ( dim_num, level_max, rule, point_num, 
      sparse_weight );

    weight_sum = r8vec_sum ( point_num, sparse_weight );

    weight_sum_error = r8_abs ( weight_sum - weight_sum_exact );

    cout << "  " << setw(8)  << level_max
         << "  " << setw(14) << weight_sum
         << "  " << setw(14) << weight_sum_exact
         << "  " << setw(14) << weight_sum_error << "\n";

    delete [] sparse_weight;
  }
  return;
}
//***************************************************************************80

void sparse_grid_mixed_write_test ( int dim_num, int level_max, int rule[], 
  char *file_name )

//***************************************************************************80
//
//  Purpose:
//
//    SPARSE_GRID_MIXED_WRITE_TEST tests SPARSE_GRID_MIXED_WRITE.
//
//  Licensing:
//
//    This code is distributed under the GNU LGPL license.
//
//  Modified:
//
//    02 October 2008
//
//  Author:
//
//    John Burkardt
//
//  Parameters:
//
//    Input, integer DIM_NUM, the spatial dimension.
//
//    Input, integer LEVEL_MAX, the level that defines the grid.
//
//    Input, int RULE[DIM_NUM], the rule in each dimension.
//     1, "CC",  Clenshaw Curtis, Closed Fully Nested rule.
//     2, "F2",  Fejer Type 2, Open Fully Nested rule.
//     3, "GP",  Gauss Patterson, Open Fully Nested rule.
//     4, "GL",  Gauss Legendre, Open Weakly Nested rule.
//     5, "GH",  Gauss Hermite, Open Weakly Nested rule.
//     6, "GGH", Generalized Gauss Hermite, Open Weakly Nested rule.
//     7, "LG",  Gauss Laguerre, Open Non Nested rule.
//     8, "GLG", Generalized Gauss Laguerre, Open Non Nested rule.
//     9, "GJ",  Gauss Jacobi, Open Non Nested rule.
//    10, "GW",  Golub Welsch, (presumed) Open Non Nested rule.
//
//    Input, char *FILE_NAME, the main name of the 
//    output files.
//
{
  int point_num;
  double *sparse_point;
  double *sparse_weight;

  cout << "\n";
  cout << "SPARSE_GRID_MIXED_WRITE_TEST\n";
  cout << "  SPARSE_GRID_MIXED_WRITE writes a sparse grid rule\n";
  cout << "  to X, W and R files.\n";
  cout << "\n";

  point_num = sparse_grid_mixed_size ( dim_num, level_max, rule );

  sparse_point = new double [ dim_num * point_num ];

  sparse_grid_mixed_point ( dim_num, level_max, rule, point_num, sparse_point );

  sparse_weight = new double[point_num];

  sparse_grid_mixed_weight ( dim_num, level_max, rule, point_num, 
    sparse_weight );

  sparse_grid_mixed_write ( dim_num, rule, point_num, sparse_weight, 
    sparse_point, file_name );

  delete [] sparse_point;
  delete [] sparse_weight;

  return;
}
