/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

#if !defined(_INDIVIDUAL)
#define _INDIVIDUAL

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <math.h>
#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
class individual  
{
public:
	
	
	
	void setNULL();
	double decode_gene(int index);
	individual &operator=(const individual &id);
	void set_chromosome(unsigned int *ch);
	void print_fn(ofstream &f);
	void print_x(ofstream &f);
	void print(ofstream &f);
	
	void InitializeI(int *);  // set proportion of each genes in the chromosome	
	void InitializeUBounds(double* );
	void InitializeLBounds(double* );
	void InitializeD(double *);
	void InitializeB(double *);
	
	void Initialize(int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,double *real_params,int withbinary);

	
	
	void set_DfitnessC(double *);

	void set_DfitnessN(double *);

	unsigned long b2d(unsigned int * digits,unsigned int lbits);
	unsigned int* d2b(unsigned long number, unsigned int &lbits);
	unsigned int *value2string(double value,int gene_index,int &lsize);  // convert a real value to a binary string

	individual();
	//individual(int,int);
	individual(int n_Genes,int n_Objs,int *GSize,double *Ub,double *Lb,double *real_params,int withbinary);
	
	
	virtual ~individual();
	


// used to be private:
	double *Dgenes;   // chromosome for real-parameters: genotype
	
	unsigned int *Bgenes;  // chromosome for binary representation: genotype
	int *Isize;   // proportion of each gene in the chromosome
	int InumberofGenes;  // number of genes in the chromosome
	int chromosome_len;

	double *DfitnessC;   // without noise
	double *DfitnessN;// with noise
	int InumberofObjs;   // number of objectives
	double DglobalFitness;     // sharing fitness
	int rank;
	
	double *Dupper;   // upper bound for each gene
	double *Dlower;// lower bound for each gene
};

#endif // !defined(AFX_INDIVIDUAL_H__58DF7132_74D3_4ED6_9BB5_3E4B7EC554A9__INCLUDED_)
