/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

#include <acro_config.h>
#if !defined(TFLOPS)

#define USING_PROBE
#include <sys/types.h>
#include <colin/OptSetup.h>
#include <colin/OptSolverUtil.h>
#include <coliny/Factory.h>

using namespace std;
using namespace utilib;

void probe() {}


void test_function(vector<double>& x, colin::real& ans)
{
ans = 0.0;
for (size_type i=0; i<x.size(); i++)
  ans += x[i]*x[i];
}

int main(int argc, char* argv[])
{
utilib::exception_mngr::set_mode(utilib::exception_mngr::Abort);
#if defined(ACRO_HAVE_MPI)
uMPI::init(&argc,&argv,MPI_COMM_WORLD);

#if 0
int tmp;
if (uMPI::rank == 0) {
   cerr << "Processor 0 waiting: pid = " << getpid() << endl;
   cin >> tmp;
   }
if (uMPI::rank == 1) {
   cerr << "Processor 1 waiting: pid = " << getpid() << endl;
   cin >> tmp;
   }
uMPI::barrier();
#endif
#endif

CommonIO::begin();
#if defined(ACRO_HAVE_MPI)
if (uMPI::rank == 0)
   CommonIO::end_tagging();
#endif


if (argc == 1) {
   cout << "simple [<solver>] [<parameter-file>] [<seed>]" << endl;
   CommonIO::end();
   exit(1);
   }

string solver_str;
string filename;
int seed;

filename = "coliny.in";
seed = 1234;

solver_str = argv[1];
if (argc > 2)
   filename = argv[2];
if (argc > 3)
   seed = atoi(argv[3]);


try {

//
// Set up the problem
// void test_function(vector<double>& x, double& answer);
//
colin::OptProblem<vector<double> > problem;
colin::OptSetup(problem,test_function,"[1.0,10.0]^3");
vector<double> initpt(3);
initpt << 9.0;

//
// Setup the solver
// Other names for solvers: direct, ms, ms.ps, ms.sw, sw, eareal, apps
//
colin::OptSolverHandle<vector<double>,colin::AppResponse<> > solver = coliny::solver_factory<vector<double>,colin::AppResponse<> >(solver_str.c_str());
//coliny::ColinySolver<colin::OptProblem<vector<double> >,vector<double> > solver;
//solver.initialize(solver_str.c_str());

if (solver_str == "help") {
   coliny::print_factory_solvers(cerr);
   exit(1);
   }

if (filename == "help") {
   solver->help_parameters(cout);
   exit(1);
   }

ifstream ifstr;
ifstr.open(filename.c_str());
if (ifstr)
   solver->read_parameter_values(ifstr);

//
// Minimize and generate summary statistics about the optimizer
//
vector<double> best_point;
colin::real best_value;
colin::solve(solver, problem, initpt, seed, true, true, best_point, best_value);
}

catch (std::exception& err) {
  cerr << "Caught STL exception: " << err.what() << endl;
  }

catch (const char* err) {
  cerr << "Caught string exception: " << err << endl;
  }

ucout << flush;
CommonIO::end();

#if defined(ACRO_HAVE_MPI)
uMPI::done();
#endif
return 0;
}

#endif
