/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

//
// show_options.cpp
//

#include <acro_config.h>
#include <utilib/sort.h>
#include <coliny/Factory.h>

using namespace std;
using namespace utilib;

int main(int argc, char* argv[])
{
if (argc < 2) {
   cerr << "show_options [-defaults -html] <solver>" << endl;
   coliny::print_factory_solvers(cerr);
   return -1;
   }

bool defaults=false;
bool html=false;
int ctr=1;
try {
  if (strcmp(argv[ctr],"-defaults")==0) {
     defaults=true;
     ctr++;
     }
  if (strcmp(argv[ctr],"-html")==0) {
     html=true;
     ctr++;
     }

  colin::OptSolverBase* opt = coliny::factory_create_base(argv[ctr]);
  if (!opt) {
     cerr << "Invalid solver name: " << argv[ctr] << endl;
     exit(1);
     }
  if (defaults)
    opt->write_parameter_values(cout);
  else if (html)
    opt->write_parameters_html(cout);
  else
    opt->write_parameters(cout,true);
  }
catch (std::exception& err) {
  cerr << "ERROR: " << err.what() << endl;
  }
return 0;
}
