/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file OptApplication.h
 *
 * Defines the colin::OptApplication class.
 */
#ifndef colin_OptApplication_h
#define colin_OptApplication_h

#include <acro_config.h>
#include <colin/OptApplicationBase.h>
#include <colin/AppResponse.h>

namespace colin {

/**
  * \class OptApplication
  *
  * An application interface class, which encapsulates the mechanics needed to 
  * executed the code for an optimization application.
  */
template <class DomainT, class ResponseT>
class OptApplication : public OptApplicationBase { 

public:
 
  /// Generic constructor.
  OptApplication() {}

  /// Destructor.
  virtual ~OptApplication() {}

  /** Return true if a reponse exists for the given point.
    * At the moment, this simply checks if the response object contains
    * response info.  In the future, this will check a database of
    * response values.
    */
  bool response_exists(DomainT& point, ResponseT& value);

  /** Store the response values for the given point.
    * This mechanism is not yet implemented.
    */
  void update_response(DomainT& point, ResponseT& response);

  /// The main evaluation routine.
  /// This is basicallhy a wrapper to \c DoEval, which processes the 
  /// \c mode and \c asv arguments.
  /// The mode reflects the type of information that is requested in
  ///		the \c asv argument.
  void Eval(DomainT& point, int mode, std::vector<int>& asv,
			int& priority, 
			ResponseT* response, bool synch_flag, int& id);

  /// The virtual function that is redefined to perform the main evaluations.
  virtual void DoEval(DomainT& point, int& priority, 
			ResponseT* response, bool synch_flag) = 0;

  ///
  void ignore_eval(const int id)
	{
	OptApplicationBase::ignore_eval(id);
	typename std::list<ResponseT*>::iterator curr = this->response_list.begin();
	typename std::list<ResponseT*>::iterator end  = this->response_list.end();
	while (curr != end) {
	  if (id == (*curr)->info->id) {
	     this->response_list.erase(curr++);
	     break;
	     }
	  curr++;
          }
	}

protected:

  /// The array of problem response that needs to be asynchronously evaluated
  std::list<ResponseT*> response_list;

  /// This will eventually be the problem response hash table.
  //AppResponseHT db;
};



//============================================================================
//
//
template <class DomainT, class ResponseT>
bool OptApplication<DomainT,ResponseT>::response_exists(DomainT& /*point*/, 
				ResponseT& response)
{
#if 0
if (db.find(Vars)) {
   AppResponse* db_response;
   db.current(db_response);
   response << *db_response;
   }
#endif
return response.info->request_flag;
}


//============================================================================
//
//
template <class DomainT, class ResponseT>
void OptApplication<DomainT,ResponseT>::update_response(DomainT& /*point*/,
				ResponseT& /*response*/)
{
#if 0
db.find(Vars);
db.update(response);
#endif
}
 

//============================================================================
//
//
template <class DomainT, class ResponseT>
void OptApplication<DomainT,ResponseT>::Eval(DomainT& point, int mode, 
			std::vector<int>& asv, int& priority, 
                        ResponseT* response, bool synch_flag, int& id)
{
response->info->mode = mode;
response->request_vector().resize(asv.size());
response->request_vector() << asv;
response->response_vector().resize(asv.size());
response->response_vector() << 0;
if ((id == -1) && (response->info->id_generate == true)) {
   neval_requested++;
   id = response->info->id = neval_requested;
   }
else
   response->info->id = id;
DoEval(point, priority, response, synch_flag);
}

} // namespace colin

#endif
