/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class GeneticAlgorithmEvaluator.

    NOTES:

        See notes of GeneticAlgorithmEvaluator.hpp

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Tue May 20 10:41:52 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the GeneticAlgorithmEvaluator class.
 */





/*
================================================================================
Includes
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {




/*
================================================================================
Nested Utility Class Implementations
================================================================================
*/
inline
void
GeneticAlgorithmEvaluator::EvaluationJob::SetResult(
    bool res
    )
{
    _result = res;
}

inline
JEGA::Utilities::Design&
GeneticAlgorithmEvaluator::EvaluationJob::GetDesign(
    ) const
{
    return _toEval;
}

inline
std::size_t
GeneticAlgorithmEvaluator::EvaluationJob::GetEvaluationNumber(
    ) const
{
    return _evalNum;
}

inline
GeneticAlgorithmEvaluator&
GeneticAlgorithmEvaluator::EvaluationJob::GetEvaluator(
    )
{
    return _evaler;
}

inline
bool
GeneticAlgorithmEvaluator::EvaluationJob::GetResult(
    ) const
{
    return _result;
}




/*
================================================================================
Inline Mutators
================================================================================
*/
inline
std::size_t
GeneticAlgorithmEvaluator::GetEvaluationConcurrency(
    ) const
{
    return _evalConcur;
}









/*
================================================================================
Inline Accessors
================================================================================
*/
inline
std::size_t
GeneticAlgorithmEvaluator::GetMaxEvaluations(
    ) const
{
    return _maxEvals;
}






/*
================================================================================
Inline Public Methods
================================================================================
*/








/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA
