/*
================================================================================
    PROJECT:

        Eddy C++ Thread Safety Project

    CONTENTS:

        Inline methods of class mutexed_variable.

    NOTES:

        See notes of mutexed_variable.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Sun Sep 14 14:16:50 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the mutexed_variable class.
 */




/*
================================================================================
Includes
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace eddy {
    namespace threads {





/*
================================================================================
Inline Mutators
================================================================================
*/








/*
================================================================================
Inline Accessors
================================================================================
*/









/*
================================================================================
Inline Public Methods
================================================================================
*/


template <typename T>
inline
void
mutexed_variable<T>::set(
    const T& to
    )
{
    mutex_lock lock(_mutex);
    _value = to;

} // set

template <typename T>
inline
T
mutexed_variable<T>::value(
    ) const
{
    mutex_lock lock(_mutex);
    return _value;

} // value

template <typename T>
inline
mutexed_variable<T>::operator T(
    ) const
{
    return value();

} // T

template <typename T>
inline
T
mutexed_variable<T>::operator ()(
    ) const
{
    return value();
}

template <typename T>
inline
const mutexed_variable<T>&
mutexed_variable<T>::operator = (
    const T& rhs
    )
{
    mutex_lock lock(_mutex);
    _value = rhs;
    return *this;
}

template <typename T>
inline
const mutexed_variable<T>&
mutexed_variable<T>::operator = (
    const my_type& rhs
    )
{
    mutex_lock lock(_mutex);
    mutex_lock rlock (&rhs._mutex);

    if(this == &rhs) return *this;
    _value = rhs._value;

    return *this;
}




/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/



template <typename T>
mutexed_variable<T>::mutexed_variable<T>(
    ) :
        _value(),
        _mutex(PTHREAD_MUTEX_RECURSIVE)
{
}

template <typename T>
mutexed_variable<T>::mutexed_variable<T>(
    const T& ival
    ) :
        _value(ival),
        _mutex(PTHREAD_MUTEX_RECURSIVE)
{
}

template <typename T>
mutexed_variable<T>::mutexed_variable<T>(
    const my_type& copy
    ) :
        _value(copy.value()),
        _mutex(PTHREAD_MUTEX_RECURSIVE)
{
}

template <typename T>
mutexed_variable<T>::~mutexed_variable<T>(
    )
{
}








/*
================================================================================
End Namespace
================================================================================
*/
    } //  namespace threads
} // namespace eddy

