/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA) Managed Front End

    CONTENTS:

        Implementation of class MBasicParameterDatabaseImpl.

    NOTES:

        See notes of MBasicParameterDatabaseImpl.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Wed Feb 08 16:29:50 2006 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the implementation of the MBasicParameterDatabaseImpl class.
 */




/*
================================================================================
Includes
================================================================================
*/
#include <stdafx.h>
#include <ManagedUtils.hpp>
#include <MBasicParameterDatabaseImpl.hpp>

#pragma unmanaged
#include <utilities/include/EDDY_DebugScope.hpp>
#include <../Utilities/include/BasicParameterDatabaseImpl.hpp>
#pragma managed







/*
================================================================================
Namespace Using Directives
================================================================================
*/
using namespace std;
using namespace System;
using namespace JEGA::Utilities;
using namespace System::Collections;







/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace FrontEnd {
        namespace Managed {





/*
================================================================================
Static Member Data Definitions
================================================================================
*/








/*
================================================================================
Mutators
================================================================================
*/








/*
================================================================================
Accessors
================================================================================
*/








/*
================================================================================
Public Methods
================================================================================
*/
ParameterDatabase&
MBasicParameterDatabaseImpl::Manifest(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return *_thePDB;
}

bool
MBasicParameterDatabaseImpl::AddIntegralParam(
    String MOH tag,
    int value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddIntegralParam(ToStdStr(tag), value);
}

bool
MBasicParameterDatabaseImpl::AddDoubleParam(
    String MOH tag,
    double value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddDoubleParam(ToStdStr(tag), value);
}

bool
MBasicParameterDatabaseImpl::AddSizeTypeParam(
    String MOH tag,
    std::size_t value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddSizeTypeParam(ToStdStr(tag), value);
}

bool
MBasicParameterDatabaseImpl::AddBooleanParam(
    String MOH tag,
    bool value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddBooleanParam(ToStdStr(tag), value);
}

bool
MBasicParameterDatabaseImpl::AddStringParam(
    String MOH tag,
    String MOH value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddStringParam(ToStdStr(tag), ToStdStr(value));
}

bool
MBasicParameterDatabaseImpl::AddDoubleVectorParam(
    String MOH tag,
    DoubleVector MOH value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddDoubleVectorParam(ToStdStr(tag), ToDoubleVector(value));
}

bool
MBasicParameterDatabaseImpl::AddIntVectorParam(
    String MOH tag,
    IntVector MOH value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    return _thePDB->AddIntVectorParam(ToStdStr(tag), ToIntVector(value));
}

bool
MBasicParameterDatabaseImpl::AddDoubleMatrixParam(
    String MOH tag,
    DoubleMatrix MOH value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    JEGA::DoubleMatrix into;
    into.resize(value->Count);
    JEGA::DoubleMatrix::size_type i=0, j=0;

    MANAGED_IENUMERATOR(DoubleVector MOH) MOH oe = value->GetEnumerator();

    while(oe->MoveNext())
    {
        MANAGED_IENUMERATOR(Double) MOH ie = NON_GENERIC_CAST(
            DoubleVector MOH, oe->Current
            )->GetEnumerator();

        while(ie->MoveNext()) into[i][j++] =
            System::Convert::ToDouble(ie->Current);
        ++i;
    }

    return _thePDB->AddDoubleMatrixParam(ToStdStr(tag), into);
}

bool
MBasicParameterDatabaseImpl::AddStringVectorParam(
    String MOH tag,
    StringVector MOH value
    )
{
    EDDY_FUNC_DEBUGSCOPE
    JEGA::StringVector svec;
    svec.resize(value->Count);
    JEGA::StringVector::size_type i=0;

    MANAGED_IENUMERATOR(String MOH) MOH oe = value->GetEnumerator();

    while(oe->MoveNext())
        svec.push_back(ToStdStr(SAFE_CAST(String MOH, oe->Current)));

    return _thePDB->AddStringVectorParam(ToStdStr(tag), svec);
}






/*
================================================================================
Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Subclass Overridable Methods
================================================================================
*/
void
MBasicParameterDatabaseImpl::MANAGED_DISPOSE(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    delete _thePDB;
    _thePDB = 0x0;
}








/*
================================================================================
Private Methods
================================================================================
*/








/*
================================================================================
Structors
================================================================================
*/


MBasicParameterDatabaseImpl::MBasicParameterDatabaseImpl(
    ) :
        _thePDB(new BasicParameterDatabaseImpl())
{
    EDDY_FUNC_DEBUGSCOPE
}

MBasicParameterDatabaseImpl::~MBasicParameterDatabaseImpl(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    MANAGED_DISPOSE();
}

/*
================================================================================
End Namespace
================================================================================
*/
        } // namespace Managed
    } // namespace FrontEnd
} // namespace JEGA


