C***********************************************************************
C Dempster-Shafer Evidence Theory implementation.
C Sandia National Laboratories 2006.
C
C At the present time, the Dempster-Shafer Evidence Theory implementation 
C is being distributed as part of the DAKOTA framework, under the DAKOTA GNU
C GPL (see the README, COPYRIGHT, and LICENSE file in the top Dakota 
C directory for more information).
C***********************************************************************
      SUBROUTINE VALID(MAXINT,MAXCMB,NV,NCMB,NI,
     1     BPA,VMIN,VMAX,CMIN,CMAX)
C      SUBROUTINE VALID(MAXV,MAXINT,MAXCMB,NV,NCMB,NI,
C     1     BPA,VMIN,VMAX,CMIN,CMAX)
C*****VALIDATE DEMPSTER-SHAFER INTERVAL DEFINITIONS
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C      DIMENSION NI(MAXV)
C      DIMENSION BPA(MAXINT,MAXV),VMIN(MAXINT,MAXV),VMAX(MAXINT,MAXV),
C     1     CMIN(MAXCMB),CMAX(MAXCMB)
      DIMENSION NI(NV)
      DIMENSION BPA(MAXINT*NV),VMIN(MAXINT*NV),VMAX(MAXINT*NV),
     1          CMIN(MAXCMB),CMAX(MAXCMB)
      LOGICAL ERROR
C
C
C*****LOOP OVER VARIABLES
      DO 2000 IV=1,NV
C********INITIALIZE TOTAL BASIC PROBABILITY FOR CURRENT VARIABLE
         TOTBPA=0.0
C********LOOP OVER INTERVALS FOR CURRENT VARIABLE
         DO 1000 II=1,NI(IV)
C***********ACCUMULATE TOTAL BASIC PROBABILITY FOR CURRENT VARIABLE
C            TOTBPA=TOTBPA + BPA(II,IV)
            TOTBPA=TOTBPA + BPA((IV-1)*MAXINT+II)
C***********CHECK THAT INTERVAL MINIMUM <= INTERVAL MAXIMUM
C            IF (VMIN(II,IV) .GT. VMAX(II,IV)) THEN
            IF (VMIN((IV-1)*MAXINT+II) .GT. VMAX((IV-1)*MAXINT+II)) THEN
C**************SET ERROR FLAG
               ERROR=.TRUE.
C**************WRITE ERROR MESSAGE
C               WRITE(2,1001) IV, NI(IV), VMIN(II,IV), VMAX(II,IV)
               WRITE(2,1001) IV, NI(IV), VMIN((IV-1)*MAXINT+II),
     1                       VMAX((IV-1)*MAXINT+II)
            ENDIF
 1000    CONTINUE
C********CHECK THAT TOTAL BASIC PROBABILITY FOR CURRENT VARIABLE SUMS TO ONE
         IF ((TOTBPA .LT. 0.99999) .OR. (TOTBPA .GT. 1.00001)) THEN
C***********SET ERROR FLAG
            ERROR=.TRUE.
C***********WRITE ERROR MESSAGE
            WRITE(2,1002) NI(IV), IV, TOTBPA
         ENDIF
 2000 CONTINUE
C*****INITIALIZE NUMBER OF INPUT INTERVAL COMBINATIONS
      NCMB=1
C*****LOOP OVER VARIABLES
      ERROR = .FALSE.
      DO 3000 IV=1,NV
         IF (NCMB*NI(IV) .GT. MAXCMB) THEN
            WRITE(2,2001)
C***********SET ERROR FLAG
            ERROR=.TRUE.
            GO TO 3100
         ENDIF
C********ACCUMULATE NUMBER OF INPUT INTERVAL COMBINATIONS
         NCMB=NCMB * NI(IV)
 3000 CONTINUE
C*****WRITE NUMBER OF COMBINATIONS
      WRITE(2,2002) NCMB
 3100 CONTINUE
      IF (ERROR) THEN
         WRITE(2,2003)
         STOP
      ENDIF
C*****LOOP OVER COMBINATIONS
      DO 4000 ICMB=1,NCMB
C********INITIALIZE MINIMUM AND MAXIMUM VALUES FOR EACH COMBINATION
         CMIN(ICMB)=1.0E30
         CMAX(ICMB)=-1.0E30
 4000 CONTINUE
      RETURN
C*****FORMAT STATEMENTS
 1001 FORMAT('>>>>>MINIMUM EXCEEDS MAXIMUM FOR VARIABLE ',I3,
     1       ', INTERVAL ',I3,', MINIMUM =',1PE9.2,', MAXIMUM =',
     2       1PE9.2)
 1002 FORMAT('>>>>>',I3,' BASIC PROBABILITY ASSIGNMENTS FOR VARIABLE ',
     1       I3,' DO NOT SUM TO 1.0 (',F10.6,')')
 2001 FORMAT(/'>>>>>INCREASE VALUE OF PARAMETER MAXCMB TO PRODUCT ',
     1        'OF NUMBER OF INTERVALS FOR EACH VARIABLE')
 2002 FORMAT(/1X,I10,' INPUT INTERVAL COMBINATIONS')
 2003 FORMAT(/'>>>>>EXECUTION TERMINATED DUE TO INPUT ERRORS')
      END
