C***********************************************************************
C Dempster-Shafer Evidence Theory implementation.
C Sandia National Laboratories 2006.
C
C At the present time, the Dempster-Shafer Evidence Theory implementation 
C is being distributed as part of the DAKOTA framework, under the DAKOTA GNU
C GPL (see the README, COPYRIGHT, and LICENSE file in the top Dakota 
C directory for more information).
C***********************************************************************
      SUBROUTINE CCBFPF(NCMB,IPBEL,IPPLA,
     1     BPAC,CMIN,CMAX)
C      SUBROUTINE CCBFPF(MAXCMB,NCMB,IPBEL, IPPLA,
C     1     BPAC,CMIN,CMAX)
C*****CALCULATE COMPLEMENTARY CUMULATIVE BELIEF FUNCTION VALUES AND
C*****COMPLEMENTARY CUMULATIVE PLAUSIBILITY FUNCTION VALUES
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION IPBEL(NCMB),IPPLA(NCMB)
      DIMENSION BPAC(NCMB),CMIN(NCMB),CMAX(NCMB)
C
C
C*****WRITE HEADER
      WRITE(*,6001)
C*****INITIALIZE TOTAL BASIC PROBABILITY
      TOTBPA=0.0
C*****LOOP OVER CELLS
      DO 1000 ICMB=1,NCMB
C********ACCUMULATE TOTAL BASIC PROBABILITY
         TOTBPA=TOTBPA + BPAC(ICMB)
C********WRITE CELL BASIC PROBABILITY ASSIGNMENTS
         WRITE(*,6002) ICMB, BPAC(ICMB), CMIN(ICMB), CMAX(ICMB)
 1000 CONTINUE
C*****LOOP OVER INPUT INTERVAL COMBINATIONS
      DO 2000 ICMB=1,NCMB
C********SET POINTER INDEX
         IPBEL(ICMB)=ICMB
         IPPLA(ICMB)=ICMB
 2000 CONTINUE
C*****SORT MINIMUM VALUES IN INCREASING ORDER FOR INPUT INTERVAL
C*****COMBINATIONS USING POINTERS
      CALL PNTSRT(NCMB,CMIN,IPBEL)
C*****WRITE HEADER
      WRITE(*,1001)
C*****INITIALIZE CUMULATIVE BELIEF VALUE
      CCBF=0.0
C*****LOOP OVER INPUT INTERVAL COMBINATIONS
      DO 3000 ICMB=NCMB,1,-1
C********TRANSFER POINTER INDEX
         I=IPBEL(ICMB)
         CCBF=CCBF + BPAC(I)
         WRITE(*,1002) I, CMIN(I), CCBF
 3000 CONTINUE
C*****SORT MAXIMUM VALUES IN INCREASING ORDER FOR INPUT INTERVAL
C*****COMBINATIONS USING POINTERS
      CALL PNTSRT(NCMB,CMAX,IPPLA)
C*****WRITE HEADER
      WRITE(*,2001)
C*****INITIALIZE CUMULATIVE PLAUSIBILITY VALUE
      CCPF=0.0
C*****LOOP OVER INPUT INTERVAL COMBINATIONS
      DO 4000 ICMB=NCMB,1,-1
C********TRANSFER POINTER INDEX
         I=IPPLA(ICMB)
         CCPF=CCPF + BPAC(I)
         WRITE(*,1002) I, CMAX(I), CCPF
 4000 CONTINUE
      RETURN
C*****FORMAT STATEMENTS
 1001 FORMAT(/' COMPLEMENTARY CUMULATIVE BELIEF VALUES',
     1       /'      COMB     VALUE        CCBF')
 1002 FORMAT(1X,I10,1P2E12.4)
 2001 FORMAT(/' COMPLEMENTARY CUMULATIVE PLAUSIBILITY VALUES',
     1       /'      COMB     VALUE        CCPF')
 6001 FORMAT(/' INPUT INTERVAL COMBINATION BASIC PROBABILITY ',
     1        'ASSIGNMENTS AND MINIMUM/MAXIMUM VALUES',
     2       /' COMBINATION    BPA           MIN         MAX')
 6002 FORMAT(1X,I10,1PE12.4,2X,1P2E12.4)
      END
