function Ke_reduced=ReduceMatrixStokes(pentaelem,Ke_temp)
%REDUCEMATRIXSTOKES - compute a reduced matrix to get rid of the bubble grid
%
%   This function return the reduced elementary matrix, so that we ca
%   solve the problem without having a grid in the middle of the pentaelem
%           [                |    ]
%           [                |    ]
%   Ke_temp=[      Kii       | Kib]
%           [                |    ]
%           [----------------+----]
%           [      Kbi       | Kbb]
%   indice b represents the bubble function (node in the middle of the penta
%   indice i represents the other nodes (the six principal nodes of the penta)
%   So that the elementary reduced matrix is Ke_reduced=Kii-Kib*Kbb^-1*Kbi
%   See theoryguide for more informations
%
%   Usage:
%      Ke_reduced=ReduceMatrixStokes(pentaelem,Ke_temp)
%
%   See also REDUCEVECTORSTOKES, CREATEKMATRIX

%Create the four matrices
Kii=Ke_temp(1:24,1:24);
Kib=Ke_temp(1:24,25:27);
Kbi=Ke_temp(25:27,1:24);
Kbb=Ke_temp(25:27,25:27);

%Add the components of the matrix for the 6 grids 
Ke_reduced=Kii-Kib*Kbb^-1*Kbi;
