function [num_gauss,first_gauss_vol_coord,second_gauss_vol_coord,third_gauss_vol_coord,fourth_gauss_vol_coord,gauss_weights]=GaussTetra(order)
%GAUSSTETRA - get Gauss point for tetra elements
%
%   This routine computes gaussian points on a reference tetra, in terms of their volume coordinates. 
%   The number of gaussian points returned depends on the order of integration ('order'). The order of 
%   integration can be computed from the polynomial degree p that needs to be integrated. The formula is: 
%   order = (p+1) /2 
%   order=1, num_gauss=1. Can integrate polynomials of degree 0 to 1
%
%   Usage:
%      [num_gauss,first_gauss_vol_coord,second_gauss_vol_coord,third_gauss_vol_coord,fourth_gauss_vol_coord,gauss_weights]=GaussTetra(order)

if order==1,
	num_gauss=1;
	gauss_weights=2*sqrt(2)/3*1;
	first_gauss_vol_coord=0.250000000000000;
	second_gauss_vol_coord=0.250000000000000;
	third_gauss_vol_coord=0.250000000000000;
	fourth_gauss_vol_coord=0.250000000000000;

elseif order==2,
	
	num_gauss=4;
	gauss_weights=2*sqrt(2)/3*[0.250000000000000, 0.250000000000000, 0.250000000000000, 0.250000000000000];
	first_gauss_vol_coord=[ 0.585410196624969, 0.138196601125011, 0.138196601125011, 0.138196601125011];
	second_gauss_vol_coord=[ 0.138196601125011, 0.585410196624969, 0.138196601125011, 0.138196601125011];
	third_gauss_vol_coord=[ 0.138196601125011, 0.138196601125011, 0.585410196624969, 0.138196601125011];
	fourth_gauss_vol_coord=[0.138196601125011, 0.138196601125011, 0.138196601125011, 0.585410196624969];

elseif order==3,
	
	num_gauss=5;
	gauss_weights=2*sqrt(2)/3*[ -0.800000000000000, 0.450000000000000, 0.450000000000000, 0.450000000000000, 0.450000000000000];
	first_gauss_vol_coord=[ 0.250000000000000, 0.500000000000000, 0.166666666666667,0.166666666666667, 0.166666666666667];
	second_gauss_vol_coord=[ 0.250000000000000, 0.166666666666667, 0.500000000000000,0.166666666666667, 0.166666666666667];
	third_gauss_vol_coord=[ 0.250000000000000, 0.166666666666667, 0.166666666666667,0.500000000000000, 0.166666666666667];
	fourth_gauss_vol_coord=[0.250000000000000, 0.166666666666667, 0.166666666666667,0.166666666666667, 0.500000000000000];

elseif order==4,
	
	num_gauss=11;
	gauss_weights=2*sqrt(2)/3*[-0.013155555555556, 0.007622222222222, 0.007622222222222,0.007622222222222, 0.007622222222222, 0.024888888888889, 0.024888888888889, 0.024888888888889, 0.024888888888889, 0.024888888888889, 0.024888888888889];
	first_gauss_vol_coord=[ 0.250000000000000, 0.785714285714286, 0.071428571428571,0.071428571428571, 0.071428571428571, 0.399403576166799,0.399403576166799, 0.399403576166799, 0.100596423833201, 0.100596423833201, 0.100596423833201];
	second_gauss_vol_coord=[0.250000000000000, 0.071428571428571, 0.785714285714286,0.071428571428571, 0.071428571428571, 0.399403576166799,0.100596423833201, 0.100596423833201, 0.399403576166799, 0.399403576166799, 0.100596423833201];
	third_gauss_vol_coord=[ 0.250000000000000, 0.071428571428571, 0.071428571428571,0.785714285714286, 0.071428571428571, 0.100596423833201,0.399403576166799, 0.100596423833201, 0.399403576166799, 0.100596423833201, 0.399403576166799];
	fourth_gauss_vol_coord=[0.250000000000000, 0.071428571428571, 0.071428571428571,0.071428571428571, 0.785714285714286, 0.100596423833201,0.100596423833201, 0.399403576166799, 0.100596423833201, 0.399403576166799, 0.399403576166799];


elseif order==5,
	
	num_gauss=15;
	gauss_weights=2*sqrt(2)/3*[0.030283678097089, 0.006026785714286, 0.006026785714286,...
                 0.006026785714286, 0.006026785714286, 0.011645249086029,...
                 0.011645249086029, 0.011645249086029, 0.011645249086029,...
                 0.010949141561386, 0.010949141561386, 0.010949141561386,...
                 0.010949141561386, 0.010949141561386, 0.010949141561386];
	first_gauss_vol_coord=[ 0.250000000000000, 0.000000000000000, 0.333333333333333,...
                 0.333333333333333, 0.333333333333333, 0.727272727272727,...
                 0.090909090909091, 0.090909090909091, 0.090909090909091,...
                 0.066550153573664, 0.066550153573664, 0.066550153573664,...
                 0.433449846426336, 0.433449846426336, 0.433449846426336];
	second_gauss_vol_coord=[0.250000000000000, 0.333333333333333, 0.000000000000000,...
                 0.333333333333333, 0.333333333333333, 0.090909090909091,...
                 0.727272727272727, 0.090909090909091, 0.090909090909091,...
                 0.066550153573664, 0.433449846426336, 0.433449846426336,...
                 0.066550153573664, 0.066550153573664, 0.433449846426336];
	third_gauss_vol_coord=[0.250000000000000, 0.333333333333333, 0.333333333333333,...
                 0.000000000000000, 0.333333333333333, 0.090909090909091,...
                 0.090909090909091, 0.727272727272727, 0.090909090909091,...
                 0.433449846426336, 0.066550153573664, 0.433449846426336,...
                 0.066550153573664, 0.433449846426336, 0.066550153573664];
	fourth_gauss_vol_coord=[ 0.250000000000000, 0.333333333333333, 0.333333333333333,...
                 0.333333333333333, 0.000000000000000, 0.090909090909091,...
                 0.090909090909091, 0.090909090909091, 0.727272727272727,...
                 0.433449846426336, 0.433449846426336, 0.066550153573664,...
                 0.433449846426336, 0.066550153573664, 0.066550153573664];


elseif order==6,
	
	num_gauss=24;
	gauss_weights=2*sqrt(2)/3*[ 0.006653791709695, 0.006653791709695, 0.006653791709695,...
                 0.006653791709695, 0.001679535175887, 0.001679535175887,...
                 0.001679535175887, 0.001679535175887, 0.009226196923942,...
                 0.009226196923942, 0.009226196923942, 0.009226196923942,...
                 0.008035714285714, 0.008035714285714, 0.008035714285714,...
                 0.008035714285714, 0.008035714285714, 0.008035714285714,...
                 0.008035714285714, 0.008035714285714, 0.008035714285714,...
                 0.008035714285714, 0.008035714285714, 0.008035714285714];
	first_gauss_vol_coord=[ 0.356191386222545, 0.214602871259152, 0.214602871259152,...
                 0.214602871259152, 0.877978124396166, 0.040673958534611,...
                 0.040673958534611, 0.040673958534611, 0.032986329573173,...
                 0.322337890142276, 0.322337890142276, 0.322337890142276,...

                 0.063661001875018, 0.063661001875018, 0.063661001875018,...
                 0.063661001875018, 0.063661001875018, 0.063661001875018,...
                 0.269672331458316, 0.603005664791649, 0.269672331458316,...
                 0.603005664791649, 0.269672331458316, 0.603005664791649];
	second_gauss_vol_coord=[0.214602871259152, 0.356191386222545, 0.214602871259152, ...
                 0.214602871259152, 0.040673958534611, 0.877978124396166, ...
                 0.040673958534611, 0.040673958534611, 0.322337890142276, ...
                 0.032986329573173, 0.322337890142276, 0.322337890142276,...

                 0.063661001875018, 0.063661001875018, 0.269672331458316, ...
                 0.603005664791649, 0.269672331458316, 0.603005664791649, ...
                 0.063661001875018, 0.063661001875018, 0.063661001875018, ...
                 0.063661001875018, 0.603005664791649, 0.269672331458316];
	third_gauss_vol_coord=[ 0.214602871259152, 0.214602871259152, 0.356191386222545, ...
                 0.214602871259152, 0.040673958534611, 0.040673958534611, ...
                 0.877978124396166, 0.040673958534611, 0.322337890142276, ...
                 0.322337890142276, 0.032986329573173, 0.322337890142276,...

                 0.269672331458316, 0.603005664791649, 0.063661001875018, ...
                 0.063661001875018, 0.603005664791649, 0.269672331458316,...
                 0.063661001875018, 0.063661001875018, 0.603005664791649,...
                 0.269672331458316, 0.063661001875018, 0.063661001875018];
	fourth_gauss_vol_coord=[0.214602871259152, 0.214602871259152, 0.214602871259152,...
                 0.356191386222545, 0.040673958534611, 0.040673958534611,...
                 0.040673958534611, 0.877978124396166, 0.322337890142276,...
                 0.322337890142276, 0.322337890142276, 0.032986329573173,...

                 0.603005664791649, 0.269672331458316, 0.603005664791649,...
                 0.269672331458316, 0.063661001875018, 0.063661001875018,...
                 0.603005664791649, 0.269672331458316, 0.063661001875018,...
                 0.063661001875018, 0.063661001875018, 0.063661001875018];
else
	error('GaussTria error message: order not supported yet');
end
