function [im,x_m,y_m]=antimread(filename,format);
%ANTINREAD - ???
%
%   Usage:
%      [im,x_m,y_m]=antimread(filename,format)

%Get radical of filename
[pathstr,name,ext,versn] = fileparts(filename);

%Build box filename
boxfilename=[pathstr '/' name '_box.exp'];

%Read box coordinates;
box=expread(boxfilename,1);

x0=min(box.x);
x1=max(box.x);
y0=min(box.y);
y1=max(box.y);

%read image
im=flipud(imread(filename,format));

%build x_m and y_m
s=size(im);
sx=s(2);
sy=s(1);


x_m=(x0+(x1-x0)/(sx-1)*(1:sx))';
y_m=(y0+(y1-y0)/(sy-1)*(1:sy))';
