function derivatives=GetParameterDerivativeValue(triaelem,grid_values,xyz_list,gauss_l1l2l3),
%GETPARAMETERDERIVATIVEVALUE - return the derivative value of a parameter at a specified point
%
%   From grid values of parameter, return parameter derivative value at gaussian point specified by gauss_l1l2l3:
%   For example, if p is the parameter,
%   dp/dx=p1*dh1/dx+p2*dh2/dx+p3*dh3/dx
%   dp/dx=p1*dh1/dx+p2*dh2/dx+p3*dh3/dx
%
%   Usage:
%      derivatives=GetParameterDerivativeValue(triaelem,grid_values,xyz_list,gauss_l1l2l3)
% 
%   See also GETPARAMETERVALUE

derivatives=zeros(2,1);

%Get dh1dh2dh3 in basic coordinate system:
dh1dh2dh3_basic=GetNodalFunctionsDerivativesBasic(triaelem,xyz_list, gauss_l1l2l3);

derivatives(1)=sum(grid_values'.*dh1dh2dh3_basic(1,:));
derivatives(2)=sum(grid_values'.*dh1dh2dh3_basic(2,:));
