% This file can be run to update the velocity archives  of the test5.
% This test deals with an icesheet with icefront for a 3d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

md=model;
md=mesh(md,'DomainOutline.exp',100000);
md=geography(md,'','');
md=parameterize(md,'Square.par');
md=extrude(md,10,3);
md=setelementstype(md,'pattyn','all');

%Compute solution with Ice model
md=solve(md,'diagnostic','ice');
archive_pattyn=md.vel;

%Save the solution in the directory
save archive_pattyn archive_pattyn

%Compute temperature with Ice model
md=solve(md,'thermalsteady','ice');
archive_temperature=md.temperature;
archive_melting=md.melting;

%Save the temperature and melting in the directory
save archive_temperature archive_temperature
save archive_melting archive_melting

%Compute temperature transient with Ice model
md=solve(md,'thermaltransient','ice');
archive_temperature_transient=md.thermaltransient_results(2).temperature;
archive_melting_transient=md.thermaltransient_results(2).melting;

%Save the temperature and melting transient in the directory
save archive_temperature_transient archive_temperature_transient
save archive_melting_transient archive_melting_transient

%Compute prognostic with Ice model
md=solve(md,'prognostic','ice');
archive_thickness=md.new_thickness;

%Save the new thickness in the directory
save archive_thickness archive_thickness

