/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file OptSolverWrapperDerived.h
 *
 * Defines the colin::OptSolverWrapperDerived class.
 */

#ifndef colin_OptSolverWrapperDerived_h
#define colin_OptSolverWrapperDerived_h

#include <acro_config.h>
#include <colin/OptSolverWrapper.h>

namespace colin {

template <class DomainT, class ResponseT>
class OptSolver;

/**
 * This class specializes an colin::OptSolverWrapper to a specific domain map.
 */
template <class DomainT, class ResponseT, class LDomainT, class LResponseT>
class OptSolverWrapperDerived : public OptSolverWrapper<DomainT,ResponseT> 
{
public:

  /// Constructor
  OptSolverWrapperDerived( OptSolver<LDomainT,LResponseT> * solver_,
			bool _own=false)
		: solver(solver_), own(_own) {}

  /// Destructor
  ~OptSolverWrapperDerived()
		{
		if (own) delete solver;
		}

  ///
  void set_initial_point(DomainT& point_)
		{
		dpoint = point_;
		map_domain(point,point_);
		solver->set_initial_point(point);
		}
  ///
  virtual OptProblem<DomainT,ResponseT> & get_problem()
                { return problem; }

  ///
  virtual const OptProblem<DomainT,ResponseT> & get_problem() const
                { return problem; }

  ///
  void set_problem(OptProblem<DomainT,ResponseT>& prob)
		{ problem &= prob; solver->set_problem(prob); }

  ///
  OptResponse<DomainT,ResponseT>& opt_response()
		{
		map_OptResponse(response, solver->opt_response());
		return response;
		}

  ///
  void opt_response(OptResponse<DomainT,ResponseT>& response_)
		{
		map_OptResponse(response_, solver->opt_response());
		}

  ///
  OptSolverBase& base()
		{return *solver;}

  ///
  OptSolverBase* operator->()
		{return solver;}

  ///
  const OptSolverBase* operator->() const
		{return solver;}

  ///
  OptSolverBase& operator*()
		{return *solver;}

  ///
  const OptSolverBase& operator*() const
		{return *solver;}

protected:

  /// If true, then delete the solver pointer
  bool own;

  /// Derived point
  DomainT dpoint;

  /// Mapped derived point
  LDomainT point;

  /// Local problem representation
  OptProblem<DomainT,ResponseT> problem;

  /// Response for the derived point
  OptResponse<DomainT,ResponseT> response;

  /// Reference for the solver
  OptSolver<LDomainT,LResponseT>* solver;

};

}

#endif
