%ANTOUTLINE - script that read in outline of antarctica and display. 

xbounds=xlim;
ybounds=xlim;

x0=xbounds(1);x1=xbounds(2);
y0=ybounds(1);y1=ybounds(2);


%figure out where we want to put the outline.
disp('Select south-west corner of outline image');
[x,y]=ginput(1)

position_axes=get(gca,'Position')
position_outline=[position_axes(1)+(x-x0)/(x1-x0),position_axes(2)+(y-y0)/(y1-y0),.15,.15]
load /proj/tpfimos/larour/Glaciology/Model_Data/Mosaic_Tiff/antarctica_outline
outline_axes=axes('Position',position_outline);
imagesc(outlinex,outliney,outline);set(outline_axes,'YDir','normal');
set(outline_axes,'XTick',[]); set(outline_axes,'YTick',[]);
set(outline_axes,'XTickLabel',[]); set(outline_axes,'YTickLabel',[]);

hold on;

%build box inside the continent
for i=1:50,
	plot(x0:500:x1,(y0+500*i)*ones(length(x0:500:x1),1),'r');
	plot(x0:500:x1,(y1-500*i)*ones(length(x0:500:x1),1),'r');
	plot((x0+500*i)*ones(length(y0:500:y1),1),y0:500:y1,'r');
	plot((x1-500*i)*ones(length(y0:500:y1),1),y0:500:y1,'r');
end
%make border
for i=1:50,
	plot(min(outlinex):500:max(outlinex),(min(outliney)+500*i)*ones(length(min(outlinex):500:max(outlinex)),1),'w');
	plot(min(outlinex):500:max(outlinex),(max(outliney)-500*i)*ones(length(min(outlinex):500:max(outlinex)),1),'w');
	plot((min(outlinex)+500*i)*ones(length(min(outliney):500:max(outliney)),1),min(outliney):500:max(outliney),'w');
	plot((max(outlinex)-500*i)*ones(length(min(outliney):500:max(outliney)),1),min(outliney):500:max(outliney),'w');
end

