/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:        OrthogPolyApproximation
//- Description:  Implementation code for OrthogPolyApproximation class
//-               
//- Owner:        Mike Eldred

#include "BasisPolyApproximation.H"
//#include "BasisPolynomial.H"
//#include "NonDQuadrature.H"
#include "ProblemDescDB.H"


namespace Dakota {

BasisPolyApproximation::
BasisPolyApproximation(const ProblemDescDB& problem_db, const size_t& num_acv):
  Approximation(BaseConstructor(), problem_db, num_acv),
  expCoeffsSolnApproach(SAMPLING), expansionCoeffFlag(true),
  expansionGradFlag(false), integrationRep(NULL)
{ }

} // namespace Dakota
