/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class GeneticAlgorithm.

    NOTES:

        See notes of GeneticAlgorithm.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Thu May 15 08:25:23 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the GeneticAlgorithm class.
 */



/*
================================================================================
Includes
================================================================================
*/




/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {







/*
================================================================================
Inline Mutators
================================================================================
*/






/*
================================================================================
Inline Accessors
================================================================================
*/
inline
eddy::utilities::uint64_t
GeneticAlgorithm::GetInstanceNumber(
    ) const
{
    return _instanceNum;
}

inline
JEGA::Utilities::DesignTarget&
GeneticAlgorithm::GetDesignTarget(
    )
{
    return _target;
}

inline
const JEGA::Utilities::DesignTarget&
GeneticAlgorithm::GetDesignTarget(
    ) const
{
    return _target;
}

inline
JEGA::Utilities::DesignGroup&
GeneticAlgorithm::GetPopulation(
    )
{
    return _pop;
}

inline
const JEGA::Utilities::DesignGroup&
GeneticAlgorithm::GetPopulation(
    ) const
{
    return _pop;
}

inline
JEGA::Utilities::DesignGroup&
GeneticAlgorithm::GetOffspring(
    )
{
    return _cldrn;
}

inline
const JEGA::Utilities::DesignGroup&
GeneticAlgorithm::GetOffspring(
    ) const
{
    return _cldrn;
}

inline
bool
GeneticAlgorithm::IsWritingPopEachGen(
    ) const
{
    return _printPopEachGen;
}

inline
bool
GeneticAlgorithm::IsWritingFinalData(
    ) const
{
    return _printFinalData;
}

inline
bool
GeneticAlgorithm::IsWritingDiscards(
    ) const
{
    return _printDiscards;
}




/*
================================================================================
Inline Public Methods
================================================================================
*/
inline
const std::string&
GeneticAlgorithm::GetName(
    ) const
{
   return _name;
}

inline
const std::string&
GeneticAlgorithm::GetFinalDataFilename(
    ) const
{
    return _finalDataFile;
}

inline
const GeneticAlgorithmMutator&
GeneticAlgorithm::GetMutator(
    ) const
{
    return GetOperatorSet().GetMutator();
}

inline
const GeneticAlgorithmConverger&
GeneticAlgorithm::GetConverger(
    ) const
{
    return GetOperatorSet().GetConverger();
}

inline
const GeneticAlgorithmCrosser&
GeneticAlgorithm::GetCrosser(
    ) const
{
    return GetOperatorSet().GetCrosser();
}

inline
const GeneticAlgorithmFitnessAssessor&
GeneticAlgorithm::GetFitnessAssessor(
    ) const
{
    return GetOperatorSet().GetFitnessAssessor();
}

inline
const GeneticAlgorithmInitializer&
GeneticAlgorithm::GetInitializer(
    ) const
{
    return GetOperatorSet().GetInitializer();
}

inline
const GeneticAlgorithmSelector&
GeneticAlgorithm::GetSelector(
    ) const
{
    return GetOperatorSet().GetSelector();
}

inline
const GeneticAlgorithmEvaluator&
GeneticAlgorithm::GetEvaluator(
    ) const
{
    return GetOperatorSet().GetEvaluator();
}

inline
const GeneticAlgorithmNichePressureApplicator&
GeneticAlgorithm::GetNichePressureApplicator(
    ) const
{
    return GetOperatorSet().GetNichePressureApplicator();
}

inline
const GeneticAlgorithmMainLoop&
GeneticAlgorithm::GetMainLoop(
    ) const
{
    return GetOperatorSet().GetMainLoop();
}

inline
const GeneticAlgorithmOperatorGroup&
GeneticAlgorithm::GetOperatorGroup(
    ) const
{
    return *_opGroup;
}

inline
const JEGA::Utilities::RegionOfSpace&
GeneticAlgorithm::GetMyRegion(
    ) const
{
    return _myDesignSpace;
}

inline
bool
GeneticAlgorithm::IsFinalized(
    ) const
{
    return _isFinalized;
}

inline
bool
GeneticAlgorithm::IsInitialized(
    ) const
{
    return _isInitialized;
}




/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/
inline
JEGA::Logging::Logger&
GeneticAlgorithm::GetLogger(
    ) const
{
    return _log;
}

inline
GeneticAlgorithmMutator&
GeneticAlgorithm::GetMutator(
    )
{
    return GetOperatorSet().GetMutator();
}

inline
GeneticAlgorithmConverger&
GeneticAlgorithm::GetConverger(
    )
{
    return GetOperatorSet().GetConverger();
}

inline
GeneticAlgorithmCrosser&
GeneticAlgorithm::GetCrosser(
    )
{
    return GetOperatorSet().GetCrosser();
}

inline
GeneticAlgorithmFitnessAssessor&
GeneticAlgorithm::GetFitnessAssessor(
    )
{
    return GetOperatorSet().GetFitnessAssessor();
}

inline
GeneticAlgorithmInitializer&
GeneticAlgorithm::GetInitializer(
    )
{
    return GetOperatorSet().GetInitializer();
}

inline
GeneticAlgorithmSelector&
GeneticAlgorithm::GetSelector(
    )
{
    return GetOperatorSet().GetSelector();
}

inline
GeneticAlgorithmPostProcessor&
GeneticAlgorithm::GetPostProcessor(
    )
{
    return GetOperatorSet().GetPostProcessor();
}

inline
GeneticAlgorithmEvaluator&
GeneticAlgorithm::GetEvaluator(
    )
{
    return GetOperatorSet().GetEvaluator();
}

inline
GeneticAlgorithmMainLoop&
GeneticAlgorithm::GetMainLoop(
    )
{
    return GetOperatorSet().GetMainLoop();
}

inline
GeneticAlgorithmNichePressureApplicator&
GeneticAlgorithm::GetNichePressureApplicator(
    )
{
    return GetOperatorSet().GetNichePressureApplicator();
}








/*
================================================================================
Inline Private Methods
================================================================================
*/







/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA
