/* \file WriteData.c:
 * \brief: general interface for writing data
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../include/macros.h"
#include "./shared/shared.h"
#include "./io.h"

#undef __FUNCT__ 
#define __FUNCT__  "WriteData"

#ifdef _SERIAL_

#include <mex.h>
void WriteData(mxArray** pdataref,void* data,int M,int N,char* data_type,char* sub_data_type){
	
	SerialWriteData(pdataref,data,M,N,data_type,sub_data_type);
}
#else
void WriteData(int* pdummy,void* data,char* data_type){
	
	/*In parallel mode, WriteData is not used, instead we access the data directly through pointers in the solution sequences. */
}
#endif
