function displayoutlines(md);
%DISPLAYOUTLINES - display outline information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays outline information from model md, 
%   only if requested.
%
%   Usage:
%      displayoutline(md)

disp(sprintf('   Outlines:'));
if isnan(md.domainoutline), disp(sprintf('      domainoutline: N/A')); else disp(sprintf('      domainoutline: not displayed (can be accessed by typing md.domainoutline)'));end
if isnan(md.riftoutline), disp(sprintf('      riftoutline: N/A')); else disp(sprintf('      riftoutline: not displayed (can be accessed by typing md.riftoutline)'));end
if isnan(md.iceshelfoutline), disp(sprintf('      iceshelfoutline: N/A')); else disp(sprintf('      iceshelfoutline: not displayed (can be accessed by typing md.iceshelfoutline)'));end
if isnan(md.icesheetoutline), disp(sprintf('      icesheetoutline: N/A')); else disp(sprintf('      icesheetoutline: not displayed (can be accessed by typing md.icesheetoutline)'));end
disp(sprintf('   Model files:'));
if isnan(md.parameterfile), disp(sprintf('      parameterfile: N/A')); else disp(sprintf('      parameterfile: not displayed (can be accessed by typing md.parameterfile)'));end
