function LaunchQueueJobgemini(md,executionpath)
%LAUNCHQUEUEJOBGEMINI - ...
%
%   Usage:
%      LaunchQueueJobgemini(md,executionpath)

%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobgemini error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobgemini error message: queueing script issing, cannot go forward');
end

%jpload both files to cluster
disp('uploading input file,  queueing script and variables script');
eval(['!scp ' md.name '.bin' ' ' md.name '.queue '  md.cluster ':' executionpath]);

disp('launching solution sequence on remote cluster');
%now call the queuing script to launch the job.
system(['ssh  ' md.cluster ' ''cd ' executionpath ' && bsub <  ' md.name '.queue ''']);
