function mu=GetViscosity2d(matice,epsilon)
%GETVISCOSITY2D - returns viscosity from a tensor, using Glen's flow law
%
%   From a string tensor and a material object, return viscosity, using Glen's flow law.
%	                                  2*B
%	 mu= -------------------------------------------------------------------
%	      2[ exx^2+eyy^2+exx*eyy+exy^2+exz^2+eyz^2 ]^[(n-1)/2n]
%	 
%	 where mu is the viscotiy, B the flow law parameter , (u,v) the velocity 
%	 vector, and n the flow law exponent.
%	 
%	 If epsilon is NULL, it means this is the first time Emg is being run, and we 
%	 return 10^14, initial viscosity.
%
%   This routine is appropriate for 2d elements.
%	
%   Usage:
%      mu=GetViscosity2d(matice,epsilon)

eps0=10^-27;
if matice.n==1,
	%Viscous behaviour.  mu=*B;
	mu=matice.B;
else
	%Non linear creep
	if norm(epsilon,2)~=0, 

		B=matice.B;
		n=matice.n;

		exx=epsilon(1);
		eyy=epsilon(2);
		exy=epsilon(3);

		%Build viscosity: mu=2*B/(2*A^e):
		A=exx^2+eyy^2+exy^2+exx*eyy+eps0^2;
		e=(n-1)/2/n;
		mu=2*B/(2*A^e);

	else
		mu=10^14;
	end
end
