/* \file macros.h
 * \brief: global macros used in the whole code
 */


#ifndef _MACROS_H_
#define _MACROS_H_


/*Printing macro: */
#define _printf_(...) PrintfFunction(__VA_ARGS__)


/*The following macros hide the error exception handling in a matlab module. Just put 
 * MODULEBOOT(); and MODULEEND(); at the beginning and end of a module, and c++ exceptions 
 * will be trapped. Really nifty!*/

#ifdef _SERIAL_

#define MODULEBOOT(); ModuleBoot(); \
	try{

#define MODULEEND(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		mexErrMsgTxt(" ");\
	}\
	catch (exception& e) {\
		_printf_("Standard exception: %s\n",e.what());\
		mexErrMsgTxt(" ");\
	}



#else 


#define MODULEBOOT(); ModuleBoot(); \
	try{

#define MODULEEND(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		return 1;\
	}\
	catch (exception& e) {\
		_printf_("Standard exception: %s\n",e.what());\
		return 1;\
	}

#endif

#endif

