#include "petsc.h"
#include "petscfix.h"
/* slepcutil.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepc.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcvecsetrandom_ SLEPCVECSETRANDOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcvecsetrandom_ slepcvecsetrandom
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcishermitian_ SLEPCISHERMITIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcishermitian_ slepcishermitian
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepccheckorthogonality_ SLEPCCHECKORTHOGONALITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepccheckorthogonality_ slepccheckorthogonality
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  slepcvecsetrandom_(Vec x, int *__ierr ){
*__ierr = SlepcVecSetRandom(
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL  slepcishermitian_(Mat A,PetscTruth *is, int *__ierr ){
*__ierr = SlepcIsHermitian(
	(Mat)PetscToPointer((A) ),is);
}
void PETSC_STDCALL  slepccheckorthogonality_(Vec *V,PetscInt *nv,Vec *W,PetscInt *nw,Mat B,PetscScalar *lev, int *__ierr ){
*__ierr = SlepcCheckOrthogonality(V,*nv,W,*nw,
	(Mat)PetscToPointer((B) ),lev);
}
#if defined(__cplusplus)
}
#endif
