function expconcatenate(newfile,oldfile)
%EXPCONCATENATE - modify several profiles to concatenate them
% 
%   this routine reads the profiles of oldfile and enables the user to concatenate
%   the profiles by clicking on the tips he/she wants to link
%
%   Usage:
%      expconcatenate(newfile,oldfile)
%
%   See also EXPMASTER, EXPDOC
 
%Some checks
if nargin~=2 | nargout
	error('expconcatenate usage: expconcatenate(newfile,oldfile)')
elseif ~exist(oldfile)
	error(['expconcatenate error message: the file ' oldfile  'does not exist'])
elseif exist(newfile),
	choice=input(['A file ' newfile ' already exists, do you want to modify it? (y/n)'],'s');
	if ~strcmpi(choice,'y'),
		error('no modification done ... exiting');
	end
end

%Get exp oldfile
[path root ext ver]=fileparts(oldfile);
A=expread(oldfile,1);
numprofiles=size(A,2);

%Figure out how nany plots have been done so far 
g=get(gca,'children'); 
prevplot=length(g);

%plot existing profile
hold on
numpoints=0;
closed=zeros(numprofiles,1);
for i=1:numprofiles
	plot(A(i).x,A(i).y,'-r','MarkerSize',10);

	%update numpoints
	numpoints=numpoints+size(A(i).x,1);

	%figure out if the profile is closed or not
	if (A(i).x(1)==A(i).x(end) & A(i).y(1)==A(i).y(end))
		closed(i)=1;
	end
end

%call merge profile routine
[A,numprofiles,numpoints,closed]=mergeprofiles(A,numprofiles,numpoints,closed,prevplot,root);

hold off

%write contour using expwrite
title('New file written, exiting','FontSize',14);
expwrite(A,newfile);
