%
%  display for the normal_uncertain class.
%
%  []=display(nuv)
%
function []=display(nuv)

if ~isa(nuv,'normal_uncertain')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(nuv),'normal_uncertain');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(nuv)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(nuv),inputname(1),string_dim(nuv,i)));
    disp(sprintf('    descriptor: ''%s'''  ,nuv(i).descriptor));
    disp(sprintf('          mean: %g'      ,nuv(i).mean));
    disp(sprintf('        stddev: %g'      ,nuv(i).stddev));
    disp(sprintf('         lower: %g'      ,nuv(i).lower));
    disp(sprintf('         upper: %g\n'    ,nuv(i).upper));
end

end
