function md=loadresultsfromdisk(md,filename,solutiontype)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%We convert all results to m/a units, from m/s

if ((nargin~=3) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end


results=parseresultsfromdisk(filename);

%First get solution type
analysis_type=results{1};

%Get gsize
gsize=results{2};

%Get part
part=results{3};

%now to specialized reading
if strcmpi(analysis_type,'diagnostic_horiz'),

	%Get u_g
	u_g=results{4};

	%Used to recover velocities
	indx=part(1:2:end);
	indy=part(2:2:end);

	%Recover velocity
	md.vx=u_g(indx)*md.yts;
	md.vy=u_g(indy)*md.yts;
	md.vel=sqrt(md.vx.^2+md.vy.^2);

elseif strcmpi(analysis_type,'control'),

	%read num_control_parameters
	num_control_parameters=results{4};
	nsteps=results{5};
	
	%read J
	md.cont_J=results{6};

	%Used to recover parameters and velocit
	indx=part(1:2:end);
	indy=part(2:2:end);

	%read parameters
	for i=1:num_control_parameters,
		control_parameter=results{6+i};
		cont_parameters{i}=control_parameter(indx);
	end
	md.cont_parameters=cont_parameters;

	%Recover velocity
	u_g=results{7+num_control_parameters};

	md.cont_vx=u_g(indx)*md.yts;
	md.cont_vy=u_g(indy)*md.yts;
	md.cont_vel=sqrt(md.cont_vx.^2+md.cont_vy.^2);
elseif strcmpi(analysis_type,'thermalsteady'),

	%read t_g
	t_g=results{4};

	%Used to recover velocities
	indx=1:6:gsize;
	indx=indx(part);

	%Recover velocity
	md.temperature=t_g(indx);
else
	error(['loadresultsfromdisk error message: unknow solution type ',analysis_type]);
end


%Check result is consistent
disp(sprintf('%s\n','checking result consistency'));

if ~isresultconsistent(md,solutiontype),
	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
end
