/*\file Mergesolutionfromftog.c
 *\brief: merge solution back from f set into g set
 */

#include "./Mergesolutionfromftog.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Vec uf=NULL;
	Mat Gmn=NULL;
	Vec ys=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec ug=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MergesolutionfromftogUsage);

	/*Input datasets: */
	FetchData((void**)&uf,NULL,NULL,UF,"Vector",NULL);
	FetchData((void**)&Gmn,NULL,NULL,GMN,"Matrix",NULL);
	FetchData((void**)&ys,NULL,NULL,YS,"Vector",NULL);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce vector: */
	Mergesolutionfromftogx(&ug, uf,Gmn,ys,nodesets);

	/*write output datasets: */
	WriteData(UG,ug,0,0,"Vector",NULL);

	/*Free ressources: */
	VecFree(&uf);
	MatFree(&Gmn);
	VecFree(&ys);
	delete nodesets;
	VecFree(&ug);

	/*end module: */
	MODULEEND();
}

void MergesolutionfromftogUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [ug] = %s(uf,Gmn,ys,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
