function display(a)
%DISPLAY - display the fields of a model
%
%   echo function for 'model' class
	
disp(sprintf('\n%s = \n',inputname(1)));
disp(sprintf('%s%s%s','   Mesh: type ''',inputname(1),'.mesh'' to display'));
disp(sprintf('%s%s%s','   Boundary conditions: type ''',inputname(1),'.bc'' to display'));

if(a.numrifts)disp(sprintf('      rifts: %i',a.numrifts));end

disp(sprintf('%s%s%s','   Observations: type ''',inputname(1),'.obs'' to display'));
disp(sprintf('%s%s%s','   Materials: type ''',inputname(1),'.mat'' to display'));
disp(sprintf('%s%s%s','   Parameters: type ''',inputname(1),'.par'' to display'));
disp(sprintf('%s%s%s','   Solution parameters: type ''',inputname(1),'.solpar'' to display'));
disp(sprintf('%s%s%s','   Results: type ''',inputname(1),'.res'' to display'));
disp(sprintf('%s%s%s','   ExpPar: type ''',inputname(1),'.exppar'' to display'));
disp(sprintf('%s%s%s','   Qmu: type ''',inputname(1),'.qmu'' to display'));

%Diverse
disp(sprintf('   Miscellaneous:'));
if isempty(a.name),
	disp(sprintf('      name: N/A'));
else
	disp(sprintf('      name: %s',a.name));
end

%notes: a.notes is a cell array of strings
if isempty(a.notes),
	disp(sprintf('      notes: N/A'));
else
	if iscell(a.notes),
		strings=a.notes;
		for i=1:length(strings),
			string=char(strings(i));
			if i==1,
				disp(sprintf('      notes: %s',string));
			else
				disp(sprintf('             %s',string));
			end
		end
	elseif ischar(a.notes),
		disp(sprintf('      notes: %s',a.notes));
	else
		disp('display error message: ''notes'' for model is neither a cell array of string, nor a string. Cannot display.');
	end
end

%repository
if ~isempty(a.repository),
	disp(sprintf('      repository: %s',a.repository));
end


end

function struct_display(structure,offset)
disp(sprintf('%s',[offset '1x' num2str(size(structure,2)) ' struct array with fields:']));
structure_fields=fields(structure);
for i=1:length(structure_fields),
	disp(sprintf('%s',[offset '   ' structure_fields{i}]));
end

end
